<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#07030c">
    <meta name="theme-color" content="#07030c">

    <link rel="apple-touch-icon" href="{{ asset('assets/images/' . site('favicon')) }}">
    <link rel="icon" href="{{ asset('assets/images/' . site('favicon')) }}">

    <title>{{ $page_title }} | {{ site('name') }}</title>
    <meta name="author" content="support@rescron.com">
    <meta name="description" content="{{ site('seo_description') }}">
    <meta property="og:url" content="{{ request()->url }}">
    <meta property="og:title" content="{{ $page_title }} | {{ site('name') }}">
    <meta property="og:description" content="{{ site('seo_description') }}">
    <meta property="og:image" content="{{ asset('assets/images/' . site('cover')) }}">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@glidejs/glide"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>


    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide/dist/css/glide.core.min.css">
    <link href="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.6.1/dist/css/splide.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">

    <link rel="stylesheet" href="{{ asset('/assets/templates/dome/css/output.css?v=1.3') }}">
    <link rel="stylesheet" href="{{ asset('/assets/templates/dome/css/front_main.css') }}">

    <link rel="shortcut icon" href="{{ asset('assets/images/' . site('favicon')) }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ asset('assets/images/' . site('favicon')) }}" type="image/x-icon">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">
    <style>
        .button-spinner {
            border: 4px solid #60A4F6;
            /* Light grey background */
            border-top: 4px solid #A320D8;
            /* Blue color for the spinner */
            border-radius: 50%;
            width: 25px;
            height: 25px;
            animation: spin 1s linear infinite;
            /* Spinning animation */
            display: inline-block;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .not-allowed-cursor {
            cursor: not-allowed;
        }

        .disabled-button {
            background-color: #6b6b6b !important;
            cursor: not-allowed !important;
            color: #fff !important;
            font-weight: bold;
            pointer-events: none !important;
        }
    </style>
</head>

<body class="bg-black"
    style="background-image: url({{ asset('/assets/templates/dome/images/front/backgroundLoginPage.png') }});">

    @if (site('preloader') == 1)
        @include('templates.' . site('template') . '.loaders.front_preloader')
    @endif
    <!-- template-->
    <div class="w-full h-screen">

        @yield('contents')

    </div>


    {{-- Include SweetAlert2 JavaScript file --}}
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>

    <script src="{{ asset('/assets/templates/dome/scripts/front_main.js') }}"></script>

    @yield('scripts')

    @stack('scripts')

    {{-- livechat --}}
    {!! json_decode(site('livechat')) !!}
</body>

</html>
