@php
    
    $page_title = 'About ' . site('name');
    $short_description = site('name') . ' uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.';
    
@endphp

{{-- layout --}}
@extends('templates.'. site('template') .'.layouts.front')

@section('css')
    
@endsection

@section('header')
<div class="w-full flex-1 lg:py-32">
  <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


    <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
      <div class="flex justify-center items-center gap-3">
        <div class="line"></div>
        <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">About</span> Us</div>
        <div class="line2"></div>
      </div>

      <div class="block text-center py-3">
        <p class="lg:text-2xl text-lg text-white font-extralight"> 
          <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">About Us</a>
        </p>
      </div>
    </div>

    <div class="block max-w-screen-lg mx-auto mb-10 p-2">
      <p class="text-center text-[#95E3FD] uppercase py-5">Revolutionizing the World of Trading</p>
      <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
        <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Welcome to <b class="font-bold">{{ site('name') }}</b></span>
      </p>

      <p class="lg:text-2xl text-lg text-white font-extralight text-center">At {{ site('name') }} we are pioneers in the world of financial technology. Our mission is to empower traders, both novice and seasoned, with a powerful yet user-friendly platform that simplifies the complexities of trading. With our advanced AI robots, extensively trained on extensive trading data and cutting-edge algorithms, we offer an unparalleled trading experience.</p>
    </div>

    <div class="flex justify-center gap-10">
      <a href="{{ route('user.register') }}" class="lg:w-52 border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">Sign Up</a>
      <a href="{{ route('user.login') }}" class="button_gradient">Login</a>
    </div>




  </div>
</div>
@endsection


@section('contents')
{{-- know us --}}
<section class="w-full mb-10 lg:mb-40" data-aos="fade-up">
  <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
    <div class="lg:grid grid-cols-2">
      <div class="col-span-1 flex items-center h-full">
        <div class="block max-w-xl lg:mb-24 mb-10">
          <div class="flex justify-center items-center gap-3">
            <div class="pricing-text text-[#95E3FD] uppercase">Know Us</div>
            <div class="line2"></div>
          </div>

          <div class="block text-start py-3">
            <p class=" lg:text-6xl text-2xl font-extralight bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#0E63B7] to-[30%] bg-clip-text text-transparent mb-4">About </p>
            <p class="lg:text-6xl text-2xl lg:mb-3 font-bold">
              <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">{{ site('name') }}</span>
            </p>
          </div>

          <div class="block">
            <p class="lg:text-xl text-white font-extralight">{{ site('name') }} uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.</p>
            <img src="{{ asset('/assets/templates/dome/images/front/data-visualization-concept-people-teamwork-isometric-icon-corporations-server-room-b1.png') }}" alt="3d image" class="lg:hidden block">
          </div>
        </div>
      </div>
      <div class="col-span-1 lg:block hidden">
        <img src="{{ asset('/assets/templates/dome/images/front/data-visualization-concept-people-teamwork-isometric-icon-corporations-server-room-b1.png') }}" alt="3d image" class="w-full">
      </div>
    </div>
  </div>      
</section>

{{-- experienced mind at work --}}
<section class="w-full mb-10 lg:mb-40" data-aos="fade-up">
  <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
    <div class="lg:grid grid-cols-2">
      <div class="col-span-1 lg:block hidden">
        <img src="{{ asset('/assets/templates/dome/images/front/coworking-service-isometric-workspaces-employee-b1.png') }}" alt="3d image" class="w-full">
      </div>
      
      <div class="col-span-1 h-full flex justify-end items-center">
        <div class="block max-w-xl lg:mb-24 mb-10">
          <div class="flex justify-center items-center gap-3">
            <div class="line"></div>
            <div class="pricing-text text-[#95E3FD] uppercase">Experienced Minds at Work</div>
          </div>

          <div class="block text-right py-3">
            <p class=" lg:text-6xl text-2xl font-extralight bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[30%] to-[#D198F9] to-[70%] bg-clip-text text-transparent mb-4">The Team At </p>
            <p class="lg:text-6xl text-2xl lg:mb-3 font-bold">
              <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">{{ site('name') }}</span>
            </p>
          </div>

          <div class="block text-right">
            <p class="lg:text-xl text-white font-extralight">Behind every successful technology is a team of dedicated experts. Our team is a fusion of seasoned traders, data scientists, and technologists who bring a wealth of knowledge and experience. We work tirelessly to ensure {{ site('name') }} remains a frontrunner in the field.</p>
            <img src="{{ asset('/assets/templates/dome/images/front/coworking-service-isometric-workspaces-employee-b1.png') }}" alt="3d image" class="lg:hidden block">
          </div>
        </div>
      </div>
    </div>
  </div>      
</section>

{{-- revolutionizing the world --}}
<section class="w-full mb-10 lg:mb-40" data-aos="fade-up">
  <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
    <div class="lg:grid grid-cols-2">
      <div class="col-span-1 flex items-center h-full">
        <div class="block max-w-screen-md lg:mb-24 mb-10">
          <div class="flex justify-center items-center gap-3">
            <div class="pricing-text text-[#95E3FD] uppercase">Revolutionizing the World of Trading</div>
            <div class="line2"></div>
          </div>

          <div class="block text-start py-3">
            <p class=" lg:text-6xl text-2xl font-extralight bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[30%] to-[#D198F9] to-[50%] bg-clip-text text-transparent mb-4">The Technology Behind </p>
            <p class="lg:text-6xl text-2xl lg:mb-3 font-bold">
              <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">{{ site('name') }}</span>
            </p>
          </div>

          <div class="block">
            <p class="lg:text-xl text-white font-extralight">{{ site('name') }} uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.</p>
            <img src="{{ asset('/assets/templates/dome/images/front/artificial-intelligence-isometric-icon-server-room-datacenter-database-concept-b1.png') }}" alt="3d image" class="lg:hidden block">
          </div>
        </div>
      </div>
      <div class="col-span-1 lg:block hidden">
        <img src="{{ asset('/assets/templates/dome/images/front/artificial-intelligence-isometric-icon-server-room-datacenter-database-concept-b1.png') }}" alt="3d image" class="w-full">
      </div>
    </div>
  </div>      
</section>

{{-- experienced mind at work --}}
<section class="w-full mb-10 lg:mb-40" data-aos="fade-up">
  <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
    <div class="lg:grid grid-cols-2">
      <div class="col-span-1 lg:block hidden">
        <img src="{{ asset('/assets/templates/dome/images/front/process-maintaining-analysis-data-isometric-design1.png') }}" alt="3d image" class="w-full">
      </div>
      
      <div class="col-span-1 h-full flex justify-end items-center">
        <div class="block max-w-screen-md lg:mb-24 mb-10">
          <div class="flex justify-center items-center gap-3">
            <div class="line"></div>
            <div class="pricing-text text-[#95E3FD] uppercase">Experienced Minds at Work</div>
          </div>

          <div class="block text-right py-3">
            <p class=" lg:text-6xl text-2xl font-extralight bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#0E63B7] to-[30%] bg-clip-text text-transparent mb-4">Upholding Values of</p>
            <p class="lg:text-6xl text-2xl lg:mb-3 font-bold">
              <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Integrity and Transparency</span>
            </p>
          </div>

          <div class="block text-right">
            <p class="lg:text-xl text-white font-extralight">Behind every successful technology is a team of dedicated experts. Our team is a fusion of seasoned traders, data scientists, and technologists who bring a wealth of knowledge and experience. We work tirelessly to ensure {{ site('name') }} remains a front runner in the field.</p>
            <img src="{{ asset('/assets/templates/dome/images/front/process-maintaining-analysis-data-isometric-design1.png') }}" alt="3d image" class="lg:hidden block">
          </div>
        </div>
      </div>
    </div>
  </div>      
</section>

{{-- connecting --}}
<section class="w-full" data-aos="fade-up">
  <img src="{{ asset('/assets/templates/dome/images/front/realistic-black-background-with-realistic-elements-b1.png') }}" alt="crypto" class="absolute right-0 lg:block hidden z-50">
  <div class="w-full lg:pt-20">
    <div class="lg:h-[40vh] sbg-[#fff] bg-opacity-5 bg-gradient-to-r from-[#95e3fd2f]  via-[#0e63b72f] to-[#d098f92f] ">
      <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
        <div class="flex justify-start items-center">
          <div class="col-span-1">
            <div class="block max-w-screen-md lg:mb-24 mb-10">
              <div class="flex justify-center items-center gap-3">
                <div class="pricing-text text-[#95E3FD] uppercase">Revolutionizing the World of Trading</div>
                <div class="line2"></div>
              </div>
    
              <div class="block text-start py-3">
                <p class=" lg:text-6xl text-2xl font-extralight bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[30%] to-[#D198F9] to-[50%] bg-clip-text text-transparent mb-4">The Technology Behind </p>
                <p class="lg:text-6xl text-2xl lg:mb-3 font-bold">
                  <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">{{ site('name') }}</span>
                </p>
              </div>
    
              <div class="block">
                <p class="lg:text-xl text-white font-extralight">With {{ site('name') }}, you're not just trading; you're part of a revolutionary movement in the world of finance. Join us today and experience the future of trading - where innovation, technology, and your success converge.</p>
              </div>
            </div>
          </div>
        </div>
      </div> 
    </div>     
  </div>
</section>
  
@endsection

@section('scripts')

@endsection
