@php

    $page_title = 'Contact Us';
    $short_description = 'We are available 24/7. You can reach us via any of the means below.';

@endphp

{{-- layout --}}
@extends('templates.'. site('template') .'.layouts.front')


@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">
@endpush

@section('header')
<div class="w-full flex-1 lg:py-32">
    <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


      <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
        <div class="flex justify-center items-center gap-3">
          <div class="line"></div>
          <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">Contact</span> Us</div>
          <div class="line2"></div>
        </div>

        <div class="block text-center py-3">
          <p class="lg:text-2xl text-lg text-white font-extralight"> 
            <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">Contact Us</a>
          </p>
        </div>
      </div>

      <div class="block max-w-screen-lg mx-auto mb-10 p-2">
        <p class="text-center text-[#95E3FD] uppercase py-5">Contact Us</p>
        <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
          <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Get connected <b class="font-bold">with us</b></span>
        </p>

        <p class="lg:text-2xl text-lg text-white font-extralight text-center">We are available 24/7. You can reach us via any of the means below.</p>
      </div>


    </div>
  </div>
@endsection


@section('contents')
<section class="w-full mb-10" data-aos="fade-up">
    <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:py-10">
      <div class="w-full relative  border border-[#E39DFF] bg-white bg-opacity-5 border-opacity-50 lg:p-14 p-6 rounded-2xl">
        <p class="text-center text-white py-10 lg:text-2xl">Feedback Form</p>

        <form action="{{ route('contact-validate') }}" method="post" enctype="multipart/form-data" class="lg:py-10 text-white gen-form" data-action="reset">
          @csrf
            <div class="w-full mb-10">
                <input type="email" name="email" id="email" class="w-full p-4 border-white border border-opacity-15 bg-transparent rounded-xl" placeholder="Email Address*" required>
            </div>
            <div class="w-full mb-10">
                <input type="text" name="subject" id="subject" class="w-full p-4 border-white border border-opacity-15 bg-transparent rounded-xl" placeholder="Subject" required>
            </div>
            <div class="w-full mb-10">
                <textarea name="message" id="message" class="w-full lg:h-[20vh] h-10vh p-4 border-white border border-opacity-15 bg-transparent rounded-xl" placeholder="Message" required></textarea>
            </div>
            <div class="w-full mb-10">
                <button type="submit" class="w-full border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Send Message</button>
            </div>
        </form>

      </div>
    </div>      
  </section>
@endsection


@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>
@endsection
