@php
    use App\Models\Bot;

    $page_title = 'AI Bot Pricing';
    $short_description = 'We have vering portfolio ranges for our bots. Select any hat best fits your pocket';
    $bots = Bot::get();

    // bot counter
    $counter = 0;
@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')


@section('css')
@endsection


@section('header')
    <div class="w-full flex-1 lg:py-32">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


            <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">AI</span> Bots</div>
                    <div class="line2"></div>
                </div>

                <div class="block text-center py-3">
                    <p class="lg:text-2xl text-lg text-white font-extralight">
                        <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">Ai Bots</a>
                    </p>
                </div>
            </div>

            <div class="block max-w-screen-lg mx-auto mb-10 p-2">
                <p class="text-center text-[#95E3FD] uppercase py-5">Bots</p>
                <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">AI
                        Bot <b class="font-bold">Pricing</b></span>
                </p>

                <p class="lg:text-2xl text-lg text-white font-extralight text-center">We have vering portfolio ranges for
                    our bots. Select any hat best fits your pocket</p>
            </div>


        </div>
    </div>
@endsection


@section('contents')
    {{-- trade portfolio --}}
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">

            <div class="block max-w-screen-lg mx-auto">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#95E3FD]">PRICING</div>
                    <div class="line2"></div>
                </div>
            </div>

            <div class="flex justify-center w-full">
                <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">AI
                        Trading Portfolios</span>
                </p>
            </div>

            <div class="w-full grid xl:grid-cols-3 grid-cols-1 gap-10 py-16 px-3">
                @foreach ($bots as $bot)
                    @php
                        $class = 'col-span-1';
                        if ($counter % 3 == 1) {
                            $class = 'xl:col-span-2';
                        } elseif ($counter % 3 == 2) {
                            $class = 'xl:col-span-3';
                        }
                        $counter++;
                    @endphp
                    <div class="{{ $class }} text-white p-10 rounded-xl border border-[#E39DFF] bg-white bg-opacity-5 border-opacity-50"
                        data-aos="fade-up">
                        <div class="flex gap-4 mb-4">
                            <img src="{{ asset('storage/bots/' . $bot->logo) }}" alt="icon"
                                class="h-7 w-7 rounded-full">
                            <p class="text-white">{{ $bot->name }}</p>
                        </div>

                        <div class="flex text-white py-10 justify-center items-center gap-4">
                            <p class="lg:text-6xl text-4xl font-extrabold">{{ $bot->daily_min }}% - {{ $bot->daily_max }}%
                            </p>
                            <p class="font-bold">/day</p>
                        </div>

                        <div class="block lg:py-7 py-4">
                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Portfolio Range</span>
                                <span class="block text-white text-right">{{ site('currency_symbol') . $bot->min }} -
                                    {{ site('currency_symbol') . $bot->max }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Daily PNL</span>
                                <span class="block text-white text-right">{{ $bot->daily_min }}% -
                                    {{ $bot->daily_max }}%</span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Trading Duration</span>
                                <span class="block text-white text-right">{{ $bot->duration }}
                                    {{ $bot->duration_type }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Capital Returned</span>
                                <span class="block text-white text-right">Yes</span>
                            </p>
                        </div>

                        <div class="block text-center lg:py-7">
                            <a href="{{ route('user.bots.index') }}"
                                class="border rounded-full lg:py-4 py-2 px-10 block text-center text-white text-lg hover:bg-gradient-to-r hover:from-[#95E3FD] from-[50%] hover:via-[#D198F9] via-[30%] hover:to-[#ffffff] to-[70%] hover:bg-clip-text hover:text-transparent">Activate</a>
                        </div>

                        <div class="block lg:py-7 py-4">
                            <p class="text-white font-bold mb-3">Tradings Days</p>
                            @php
                                $trading_days_display = [
                                    'monday' => in_array('monday', json_decode(site('trading_days'))),
                                    'tuesday' => in_array('tuesday', json_decode(site('trading_days'))),
                                    'wednesday' => in_array('wednesday', json_decode(site('trading_days'))),
                                    'thursday' => in_array('thursday', json_decode(site('trading_days'))),
                                    'friday' => in_array('friday', json_decode(site('trading_days'))),
                                    'saturday' => in_array('saturday', json_decode(site('trading_days'))),
                                    'sunday' => in_array('sunday', json_decode(site('trading_days'))),
                                ];
                            @endphp
                            @foreach ($trading_days_display as $day => $day_display)
                                <p class="flex justify-between">
                                    @if (in_array($day, json_decode(site('trading_days'))))
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.5 9L7.5 12L13.5 6" stroke="url(#paint0_linear_7_7290)"
                                                stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round" />
                                            <defs>
                                                <linearGradient id="paint0_linear_7_7290" x1="3.96774" y1="7.2"
                                                    x2="13.1761" y2="3.45383" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#3F7DF2" />
                                                    <stop offset="0.435" stop-color="#95E3FD" />
                                                    <stop offset="1" stop-color="#A320D8" />
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            class="w-4 h-4 text-red-500" viewBox="0 0 16 16">
                                            <path
                                                d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                        </svg>
                                    @endif
                                    <span class="block text-[#B4B1B1] text-left ">{{ ucfirst($day) }}</span>
                                </p>
                            @endforeach
                        </div>
                    </div>
                @endforeach

            </div>

        </div>
    </section>
@endsection

@section('scripts')
@endsection
