@php
    use App\Models\Bot;

    $page_title = 'Privacy Policy';
    $short_description =
        'Prior to availing any of our services, we kindly request that you review and acknowledge our Privacy Policy. ';

@endphp

{{-- layout --}}
@extends('templates.'. site('template') .'.layouts.front')


@section('css')
@endsection

@section('header')
<div class="w-full flex-1 lg:py-32">
    <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


      <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
        <div class="flex justify-center items-center gap-3">
          <div class="line"></div>
          <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">Privacy</span></div>
          <div class="line2"></div>
        </div>

        <div class="block text-center py-3">
          <p class="lg:text-2xl text-lg text-white font-extralight"> 
            <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">Privacy</a>
          </p>
        </div>
      </div>

      <div class="block max-w-screen-lg mx-auto mb-10 p-2">
        <p class="text-center text-[#95E3FD] uppercase py-5">Privacy Policy</p>
        <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
          <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Privacy <b class="font-bold">Policy</b></span>
        </p>

        <p class="lg:text-2xl text-lg text-white font-extralight text-center">{{ $short_description }} </p>
      </div>


    </div>
  </div>
@endsection


@section('contents')
  {{-- terms of services --}}
  <section class="w-full mb-10 " data-aos="fade-up">
    <div class="lg:w-[70%] mx-auto lg:py-10 p-4">
      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            1. Introduction 
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            Welcome to {{ site('name') }}. At {{ site('name') }}, we respect
            your privacy and are committed to protecting your
            personal information. This Privacy Policy is designed to help you understand how we
            collect, use,
            disclose, and safeguard your personal information. By using our services, you
            consent to the
            practices described in this Privacy Policy.
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            2. Information We Collect
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">
                <p class="font-bold lg:text-lg text-white">2.1 Personal Information</p>
                <p class="lg:text-lg text-white">Personal Information is information that can be used to
                    identify you as an individual. The types of
                    Personal Information we may collect include but are not limited to:
                <ul class="text-white" style="list-style-type: disc; padding: 10px 30px;">
                    <li>Your name</li>
                    <li>Email address</li>
                    <li>Contact information</li>
                    <li>Financial information (for account verification and trading purposes)</li>
                    <li>User-generated content (such as comments, reviews, or support requests)</li>
                </ul>
                </p>
                <p class="lg:text-lg text-white mb-5">We collect this information when you voluntarily
                    provide
                    it to us, such as when you create an
                    account, communicate with us, or use our Services.</p>

                <p class="font-bold lg:text-lg text-white mt-3">2.2 Non-Personal Information</p>
                <p class="lg:text-lg text-white">Non-Personal Information is data that cannot be used to
                    identify you directly. This information
                    includes:
                <ul class="text-white" style="list-style-type: disc; padding: 10px 30px;">
                    <li>Device information (e.g., device type, operating system)</li>
                    <li>Usage data (e.g., pages visited, time spent on our platform)</li>
                    <li>Log data (e.g., IP address, browser type)</li>
                    <li>Cookies and similar technologies (see Section 5)</li>
                </ul>
                </p>
                <p class="lg:text-lg text-white">We may collect Non-Personal Information automatically as
                    you interact with our Services.</p>
                </p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            3. How We Use Your Information
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">We use the information we collect for various purposes, including
                but not limited to:</p>
            <p class="lg:text-lg text-white">
            <ul class="text-white" style="list-style-type: disc; padding: 10px 30px;">
                <li>Providing and maintaining our Services</li>
                <li>Personalizing and improving user experience</li>
                <li>Analyzing and monitoring usage patterns</li>
                <li>Sending notifications and updates</li>
                <li>Responding to your requests and inquiries</li>
                <li>Complying with legal obligations</li>
            </ul>
            </p>
        </p>
      </div>
      
      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            4. Data Retention
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">We retain your information only as long as necessary for the
                purposes outlined in this Privacy Policy
                or as required by law. When your information is no longer needed, we will securely
                delete or
                anonymize it.</p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            5. Cookies and Similar Technologies
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">{{ site('name') }} uses cookies and similar technologies to
                enhance user experience and collect Non-Personal
                Information. You can manage cookie preferences through your browser settings, but
                disabling cookies
                may affect the functionality of our Services.</p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            6. Third-Party Services and Links
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">Our Services may contain links to third-party websites or
                services. We are not responsible for the
                privacy practices or content of these third parties. We recommend reviewing their
                privacy policies
                before using their services.</p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            7. Data Security
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white"> We take data security seriously and employ industry-standard
                measures to protect your information.
                However, no method of transmission over the internet or electronic storage is
                entirely secure, and
                we cannot guarantee absolute security. </p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            8. Children's Privacy
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white"> Our Services are not intended for children under the age of 18.
                We do not knowingly collect Personal
                Information from children. If you are a parent or guardian and believe that your
                child has provided
                us with Personal Information, please contact us. </p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            9. Your Privacy Choices
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white"> You have rights regarding your Personal Information, including:</p>
            <ul class="text-white" style="list-style-type: disc; padding: 10px 30px;">
                <li>Accessing and updating your information</li>
                <li>Deleting your account</li>
                <li>Opting out of marketing communications</li>
                <li>Managing cookie preferences</li>
                <li>Withdrawing consent (where applicable)</li>
            </ul>
            <p class="text-white text-sm">You can exercise these rights by contacting us through the information provided in Section 11.</p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            10. Changes to this Privacy Policy
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white">We may update this Privacy Policy periodically to reflect changes in our practices or for legal
                reasons. Any modifications will be effective upon posting on our website. We encourage you to review
                this Privacy Policy regularly to stay informed about how we collect and protect your information.</p>
        </p>
      </div>

      <div class="w-full text-justify mb-10">
        <p class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
            11. Contact Information
        </p>
        <p class="lg:text-lg text-white font-extralight tracking-wider">
            <p class="text-white"> If you have questions or concerns about this Privacy Policy or our data practices, please contact us
                at [{{ site('email') }}]. </p>
        </p>
      </div>

    </div> 
  </section>
@endsection


@section('scripts')
@endsection
