@extends('templates.' . site('template') . '.layouts.auth')

@section('contents')
    {{-- verification form --}}
    <div class="min-h-screen w-full flex items-center justify-center" data-aos="zoom-in-up">

        <div class="block w-full">

            <div class="max-w-screen-sm mx-auto p-4" data-aos="fade-right">


                <div class="px-4 lg:px-10 mt-6 space-y-6">
                    <p id="noticeMsgOtp" class="hidden noticeMsg"
                        style="position: relative; background-color: #f8f9fa; padding: 16px; border-left: 8px solid #A22ADA; border-radius: 6px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); max-width: 400px; margin: 20px auto; ">
                    </p>
                </div>

                <div class="" id="verifyFormContainer">
                    <div class="text-white mb-10 text-center">
                        <p class="text-4xl mb-4 font-thin"><span
                                class="bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] bg-clip-text text-transparent">Input
                                2FA</p>
                        <p class="text-lg">2 Factor Authentication</p>
                    </div>

                    <form action="{{ route('user.g2fa.g2fa') }}" method="POST" class="px-4 lg:px-10 mt-6 space-y-6"
                        id="verifyForm">
                        @csrf
                        <div class="w-full mb-20 flex items-center justify-center">

                            <div class="flex lg:gap-10 gap-6 text-white">
                                <input type="number" maxlength="1" name="otp[]" autofocus
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-12 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            </div>
                            <input type="hidden" name="otp" id="otp" value="" required maxlength="6">

                            <span>
                                @error('otp')
                                    {{ $message }}
                                @enderror
                            </span>

                        </div>

                        <div class="w-full mb-4">
                            <div class="text-center">
                                <button type="submit" id="verifyBtn"
                                    class="border text-white rounded-full px-10 py-4 w-full bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Verify</button>
                            </div>
                        </div>


                    </form>
                </div>

            </div>
        </div>

    </div>
@endsection

@section('scripts')
    {{-- <script>
        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, 4);

                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });


        //////////////////////////////// parse
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });
    </script> --}}

    <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                // Allow only 1 character
                if (value.length > 1) {
                    $this.val(value.charAt(0)); // Keep only the first character
                }

                // Move focus to the next input if a character is entered
                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, $inputs.length);

                // Fill inputs with pasted data, ensuring only one character per input
                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });

                // Focus on the next input after the last pasted character
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script>
    <script>
        $(document).ready(function() {

            //otp form
            $('#verifyForm').submit(function(e) {
                e.preventDefault();

                var form = $(this);
                var formData = form.serialize();
                var clicked = $('#verifyBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                clicked.addClass('bg-gray-500');
                clicked.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        $('#noticeMsg').html(verifyText).show();
                        var url = "{{ route('user.dashboard') }}";
                        window.location.href = url;

                    },
                    error: function(xhr, status, error) {
                        $('#verifyBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                Swal.fire({
                                    icon: 'error',
                                    html: fieldErrors,
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 3000,
                                    timerProgressBar: true,
                                    didOpen: (toast) => {
                                        toast.addEventListener('mouseenter',
                                            Swal.stopTimer);
                                        toast.addEventListener('mouseleave',
                                            Swal.resumeTimer);
                                    }
                                });
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                text: 'An error occured, please try again later',
                                toast: true,
                                position: 'top-end',
                                showConfirmButton: false,
                                timer: 3000,
                                timerProgressBar: true,
                                didOpen: (toast) => {
                                    toast.addEventListener('mouseenter',
                                        Swal.stopTimer);
                                    toast.addEventListener('mouseleave',
                                        Swal.resumeTimer);
                                }
                            });
                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        clicked.removeClass('bg-gray-500');
                        clicked.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );

                    }

                });
            });

        });
    </script>
@endsection
