@extends('templates.' . site('template') . '.layouts.auth')

@section('css')
@endsection

@section('contents')
    <div class="min-h-screen w-full flex items-center justify-center" data-aos="zoom-in-up">

        <div class="block w-full">

            <div class="max-w-screen-sm mx-auto p-4" data-aos="fade-right">

                <a href="{{ route('home') }}" class="text-white flex gap-2  py-2 px-4 rounded-md w-32 mb-10">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        style="fill: #ffffff;transform: ;msFilter:;">
                        <path d="M12.707 17.293 8.414 13H18v-2H8.414l4.293-4.293-1.414-1.414L4.586 12l6.707 6.707z"></path>
                    </svg>
                    <span class="text-white">Back</span>
                </a>

                <div class="px-4 lg:px-10 mt-6 space-y-6">
                    <p id="noticeMsgOtp" class="hidden noticeMsg"
                        style="position: relative; background-color: #f8f9fa; padding: 16px; border-left: 8px solid #A22ADA; border-radius: 6px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); max-width: 400px; margin: 20px auto; ">
                    </p>
                </div>

                <div class="text-white mb-10 text-center">
                    <p class="text-4xl mb-4 font-thin"><span
                            class="bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] bg-clip-text text-transparent">Get
                            Started with, <span class="font-bold">Rescron</span></span></p>
                    <p class="text-lg">Please enter your details</p>
                </div>

                <form action="{{ route('user.register-validate') }}" method="POST" class="" id="registerForm">
                    @csrf
                    <div class="w-full mb-10">
                        <label for="email" class="text-white">Email Address</label>
                        <div class="w-full text-white border p-3 rounded-2xl mt-4">
                            <div class="w-full">
                                <input type="email" id="email" name="email"
                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                    placeholder="Enter Email Address">
                            </div>
                        </div>

                        <span>
                            @error('email')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-10">
                        <label for="password" class="text-white">Password</label>
                        <div class="w-full text-white border p-3 rounded-2xl mt-4">
                            <div class="w-full">
                                <input type="password" name="password" id="password"
                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                    placeholder="Enter Password">
                            </div>
                        </div>

                        <span>
                            @error('password')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-20">
                        <label for="confirm-password" class="text-white">Confirm Password</label>
                        <div class="w-full text-white border p-3 rounded-2xl mt-4">
                            <div class="w-full">
                                <input type="password" name="password_confirmation" id="confirm-password"
                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                    placeholder="Re-enter Password">
                            </div>
                        </div>

                        <span>
                            @error('password-confirmation')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>


                    <div class="w-full mb-4">
                        <div class="text-center">
                            <button type="submit" id="registerBtn"
                                class="border text-white rounded-full px-10 py-4 w-full bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Sign
                                Up</button>
                        </div>
                    </div>

                    <div class="w-full mb-4">
                        <p class="text-center text-[#B4B1B1]">Already have an account? <a href="{{ route('user.login') }}"
                                class="text-white"> Login </a></p>
                    </div>

                </form>

                <form action="{{ route('user.register-verify') }}" method="POST" class="hidden" id="verifyForm">
                    @csrf
                    <div class="w-full mb-20 flex items-center justify-center">

                        <div class="flex lg:gap-10 gap-6 text-white">
                            <input type="number" maxlength="1" name="otp[]" autofocus
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                        </div>
                        <input type="hidden" name="otp" id="otp" value="" required maxlength="6">

                        <span>
                            @error('email')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-4">
                        <div class="text-center">
                            <button type="submit" id="verifyBtn"
                                class="border text-white rounded-full px-10 py-4 w-full bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Send
                                Code</button>
                        </div>
                    </div>

                    <div class="text-center text-white py-5">
                        <a href="{{ route('user.register') }}" class="hover:text-purple-700" id="resendBtn">Go Back</a>
                    </div>

                </form>

            </div>
        </div>

    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#registerForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#registerBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                //custom styling
                clicked.addClass('disabled-button');
                clicked.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        var verify = response.verify;

                        toastNotify('success', verifyText);
                        $('.noticeMsg').html(verifyText).show();

                        if (verify == 1) {
                            //hide register form and display verification form
                            $('#registerForm').hide();
                            $('#verifyForm').show();

                            //update page title
                            $('#page-title').html('Verify Email');
                        } else {
                            var url = '{{ route('user.dashboard') }}';
                            window.location.href = url;
                        }




                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                toastNotify('error', fieldErrors);

                                $('.noticeMsg').html(fieldErrors).show();


                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');


                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        //custom styling
                        clicked.removeClass('disabled-button');
                        clicked.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );

                    }

                });
            });


            //otp form
            $('#verifyForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#verifyBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                //custom styling
                clicked.addClass('disabled-button');
                clicked.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        $('#noticeMsg').html(verifyText).show();

                        toastNotify('success', verifyText);



                        var url = '{{ route('user.dashboard') }}';
                        window.location.href = url;

                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });

                                toastNotify('error', fieldErrors);

                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');

                        }


                    },

                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        //custom styling
                        clicked.removeClass('disabled-button');
                        clicked.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );

                    }

                });
            });
        });
    </script>

    {{-- <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, 4);

                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script> --}}

    <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                // Allow only 1 character
                if (value.length > 1) {
                    $this.val(value.charAt(0)); // Keep only the first character
                }

                // Move focus to the next input if a character is entered
                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, $inputs.length);

                // Fill inputs with pasted data, ensuring only one character per input
                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });

                // Focus on the next input after the last pasted character
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script>
@endsection
