@php
    use Illuminate\Support\Facades\DB;
    use App\Models\DepositCoin;
    use Illuminate\Support\Facades\Cache;

    function getCurrencyByCoin($id)
    {
        // Try to retrieve the coins from the cache
        $coins = Cache::get('coins');

        // If coins are not in the cache, retrieve them from the database and cache them
        if (!$coins) {
            $coins = DepositCoin::all();
            Cache::forever('coins', $coins);
        }

        // Find and return the coin by ID
        $coin = $coins->find($id);
        return $coin;
    }

    $startDate = now()->subDays(6);
    $endDate = now();

    $deposit_data = user()
        ->deposits()
        ->selectRaw('DATE(created_at) as date, SUM(amount) as total_deposit')
        ->whereBetween('created_at', [$startDate, $endDate])
        ->groupBy('date')
        ->orderBy('date')
        ->get();

    $withdrawal_data = user()
        ->withdrawals()
        ->selectRaw('DATE(created_at) as date, SUM(amount) as total_withdrawal')
        ->whereBetween('created_at', [$startDate, $endDate])
        ->groupBy('date')
        ->orderBy('date')
        ->get();

    $graph_info = [];
    $days = [];
    $deposit_amount = [];
    $deposits_graph = [];
    $withdrawals_graph = [];

    // Create an associative array with all days within the date range and initial values of 0
    $currentDate = $startDate;
    while ($currentDate <= $endDate) {
        $formatted_date = $currentDate->format('d-m');
        $graph_info[$formatted_date] = ['deposit' => 0, 'withdrawal' => 0];
        $currentDate->addDay();
        array_push($days, $formatted_date);
    }

    // Populate the graph_info array with actual data from $chart_data
    foreach ($deposit_data as $data) {
        $formatted_date = date('d-m', strtotime($data->date));
        // $graph_info[$formatted_date] = [
        //     'deposit' => $data->total_deposit,
        // ];
        $graph_info[$formatted_date]['deposit'] = $data->total_deposit;
    }

    foreach ($withdrawal_data as $data) {
        $formatted_date = date('d-m', strtotime($data->date));
        // $graph_info[$formatted_date] = [
        //     'withdrawal' => $data->total_withdrawal,
        // ];
        $graph_info[$formatted_date]['withdrawal'] = $data->total_withdrawal;
    }

    foreach ($graph_info as $day => $data) {
        array_push($days, $day);
        array_push($deposits_graph, $data['deposit']);
        array_push($withdrawals_graph, $data['withdrawal']);
    }
    $days = array_slice($days, -7);

    //////////////////////////////// merge deposit and wihdrawal
    // Merge both collections and sort by created_at
    $user_id = user()->id;
    $deposits_blade = DB::select("SELECT * FROM deposits WHERE user_id = $user_id ORDER BY id DESC LIMIT 5");
    $withdrawals_blade = DB::select("SELECT * FROM withdrawals WHERE user_id = $user_id ORDER BY id DESC LIMIT 5");

    $deposits_and_withdrawals = collect(array_merge((array) $deposits_blade, (array) $withdrawals_blade));

    // Sort the combined collection by 'created_at' in descending order
    $deposits_and_withdrawals = $deposits_and_withdrawals->sortByDesc('created_at');

    // Now $deposits_and_withdrawals contains a combined collection of deposits and withdrawals ordered by 'created_at'

    // Corrected dd() to dump the correct variables
    //dd($deposits_and_withdrawals, $deposits_blade, $withdrawals_blade);

@endphp


@extends('templates.' . site('template') . '.layouts.user')

@section('css')
@endsection

@section('contents')
    {{-- Al Trading View chart --}}
    <section class="w-full py-6 " data-aos="fade-up" style="margin-top: 50px;">
        <div class="max-w-screen-2xl mx-auto mb-5">
            <h1
                class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-tr from-[#3F7DF2] from-[10%] via-[#60A4F6] via-[20%] via-[#95E3FD] via-[30%] to-[#A320D8] to-[40%] bg-clip-text text-transparent">
                AI Trading Overview (7 Day PNL)</h1>
            <div class="bg-cover bg-no-repeat bg-center">
                <canvas id="canvas" class="w-full min-h-[50vh]"></canvas>
            </div>
        </div>
    </section>


    {{-- WALLET START --}}
    <section class="w-full py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-3">
            <div class="grid lg:grid-cols-3 grid-cols-1 gap-3">
                <div class="col-span-1 p-2 text-white">
                    <div
                        class="w-full bg-[url(../../assets/images/dash/background-backdrop-account.png)] bg-no-repeat bg-cover bg-center border-t border-t-[#A320D8] border-b border-b-[#95E3FD] border-l border-l-[#95E3FD] border-r border-r-[#95E3FD] border-opacity-65 rounded-2xl p-6">
                        <div class="flex gap-2 items-center mb-6">
                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/material-symbols-light_account-child-outline.svg') }}"
                                alt="icon">
                            <span>Account</span>
                        </div>

                        <div class="block mb-3">
                            <p style="padding:10px"></p>
                            <p class="font-bolwd text-4xl">{{ formatAmount(user()->balance) }}</p>
                        </div>

                        {{-- @if ($percentage_deposit_increase > 0)
                                <span>+ {{ round($percentage_deposit_increase, 2) }}%</span>
                        @else
                            <span>+0%</span>
                        @endif --}}

                        @if ($percentage_deposit_increase == 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-arrow-up-right.svg') }}"
                                    alt="icon">
                                <span class="text-white">
                                    @if ($percentage_deposit_increase > 0)
                                        + {{ round($percentage_deposit_increase, 2) }}%
                                    @else
                                        0%
                                    @endif
                                </span>
                            </div>
                        @elseif($percentage_deposit_increase > 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-arrow-up-left.svg') }}"
                                    alt="icon">
                                <span class="text-[#08C949]">
                                    @if ($percentage_deposit_increase > 0)
                                        + {{ round($percentage_deposit_increase, 2) }}%
                                    @else
                                        0%
                                    @endif
                                </span>
                            </div>
                        @else
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-arrow-down-right.svg') }}"
                                    alt="icon">
                                <span class="text-[#EA0A0E]">
                                    @if ($percentage_deposit_increase > 0)
                                        + {{ round($percentage_deposit_increase, 2) }}%
                                    @else
                                        0%
                                    @endif
                                </span>
                            </div>
                        @endif



                        <div class="block">
                            @if ($percentage_deposit_increase == 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @elseif($percentage_deposit_increase > 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @else
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @endif

                        </div>
                    </div>
                </div>

                <div class="col-span-1 p-2 text-white">
                    <div
                        class="w-full bg-[url(../../assets/images/dash/background-backdrop-account.png)] bg-no-repeat bg-cover bg-center border-t border-t-[#95E3FD] border-b border-b-[#A320D8] border-l border-l-[#A320D8] border-r border-r-[#A320D8] border-opacity-65 rounded-2xl p-6">
                        <div class="flex gap-2 items-center mb-6">
                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/material-symbols-light_all-time-pnl-child-outline.svg') }}"
                                alt="icon">
                            <span>All Time PNL</span>
                        </div>

                        <div class="block mb-3">
                            <p style="padding:10px"></p>
                            <p class="font-bolwd text-4xl">{{ formatAmount($profit_fig + $capital) }}</p>
                        </div>


                        @if ($profit_percent == 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-arrow-up-right.svg') }}"
                                    alt="icon">
                                <span class="text-white">+{{ number_format($profit_percent, 2) }}%</span>
                            </div>
                        @elseif($profit_percent > 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-arrow-up-left.svg') }}"
                                    alt="icon">
                                <span class="text-[#08C949]">+{{ number_format($profit_percent, 2) }}%</span>
                            </div>
                        @else
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-arrow-down-right.svg') }}"
                                    alt="icon">
                                <span class="text-[#EA0A0E]">{{ number_format($profit_percent, 2) }}%</span>
                            </div>
                        @endif



                        <div class="block">
                            @if ($profit_percent == 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @elseif($profit_percent > 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @else
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @endif

                        </div>
                    </div>
                </div>

                <div class="col-span-1 p-2 text-white">
                    <div
                        class="w-full bg-[url(../../assets/images/dash/background-backdrop-account.png)] bg-no-repeat bg-cover bg-center border-t border-t-[#ffffff] border-b border-b-[#95E3FD] border-l border-l-[#95E3FD] border-r border-r-[#95E3FD] border-opacity-65 rounded-2xl p-6">
                        <div class="flex gap-2 items-center mb-6">
                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/material-symbols-light_account-child-outline-ai-bots.svg') }}"
                                alt="icon">
                            <span>Ai Bots</span>
                        </div>

                        <div class="block mb-3">
                            <p>No of Bots</p>
                            <p class="font-bolwd text-4xl">{{ user()->botActivations()->count() }}</p>
                        </div>

                        @php
                            $tradeCount = user()->botHistory()->count();
                        @endphp

                        @if ($tradeCount <= 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-arrow-up-right.svg') }}"
                                    alt="icon">
                                <span class="text-white">{{ user()->botHistory()->count() }} trades</span>
                            </div>
                        @elseif($tradeCount > 0)
                            <div class="flex gap-6 items-center mb-6">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-arrow-up-left.svg') }}"
                                    alt="icon">
                                <span class="text-[#08C949]">+{{ user()->botHistory()->count() }} trades</span>
                            </div>
                        @endif



                        <div class="block">
                            @if ($tradeCount <= 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @elseif($tradeCount > 0)
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-wave-up.svg') }}"
                                    alt="wave" class="w-full">
                            @endif

                        </div>


                    </div>
                </div>

            </div>
        </div>
    </section>


    {{-- my bots and recent trades --}}
    <section class="w-full py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-3">
            <div class="grid lg:grid-cols-2 grid-cols-1 gap-3">

                <!--my bots-->
                <div class="col-span-1 p-2 text-white mb-10">
                    <p
                        class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] to-[10%] bg-clip-text text-transparent">
                        My Bots</p>

                    <div class="lg:border-0 border border-[#A320D8] border-opacity-35 rounded-2xl">
                        <div class="w-full lg:border-r lg:border-r-[#A320D8] border-opacity-65 rounded-2xl p-6">
                            <div class="w-full grid grid-cols-2 mb-5">
                                <p class="text-lg text-left font-semibold mb-3">My Bots</p>
                                <p class="text-lg text-right font-extralight mb-3">Portfolio Balance</p>
                            </div>

                            <div class="w-full h-[70vh] overflow-y-auto px-3">
                                @forelse ($activations as $bot)
                                    <div class="w-full flex justify-between gap-2 mb-3">
                                        <div class="col-span-1 text-lg text-left flex gap-2 items-center mb-3">
                                            <img class="w-10 h-10 bg-white rounded-full"
                                                src="{{ asset('storage/bots/' . $bot->bot->logo) }}" alt="bots">
                                            <div>
                                                <p class="flex gap-2">
                                                    <span>{{ $bot->bot->name }}</span>
                                                    @if ($bot->status == 'active')
                                                        <svg width="24" height="25" viewBox="0 0 24 25"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M10.6319 1.64199C10.9859 1.28847 11.4595 1.08045 11.9593 1.05897C12.4591 1.0375 12.9489 1.20413 13.3319 1.52599L13.4599 1.64299L15.3599 3.54199H18.0459C18.5503 3.54209 19.036 3.73277 19.4058 4.07583C19.7756 4.4189 20.002 4.88901 20.0399 5.39199L20.0459 5.54199V8.22799L21.9459 10.128C22.2997 10.482 22.5079 10.9559 22.5293 11.4559C22.5508 11.956 22.384 12.4459 22.0619 12.829L21.9449 12.956L20.0449 14.856V17.542C20.045 18.0466 19.8545 18.5326 19.5114 18.9025C19.1683 19.2725 18.698 19.4992 18.1949 19.537L18.0459 19.542H15.3609L13.4609 21.442C13.1068 21.7958 12.633 22.004 12.1329 22.0255C11.6329 22.0469 11.1429 21.8801 10.7599 21.558L10.6329 21.442L8.73287 19.542H6.04587C5.54129 19.5422 5.0553 19.3516 4.68532 19.0085C4.31534 18.6654 4.08871 18.1951 4.05087 17.692L4.04587 17.542V14.856L2.14587 12.956C1.79206 12.602 1.58387 12.1281 1.56239 11.6281C1.54091 11.128 1.70772 10.6381 2.02987 10.255L2.14587 10.128L4.04587 8.22799V5.54199C4.04596 5.03759 4.23664 4.55185 4.57971 4.18208C4.92277 3.81231 5.39289 3.58582 5.89587 3.54799L6.04587 3.54199H8.73187L10.6319 1.64199Z"
                                                                fill="#00AA39" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M15.1255 8.52497L10.8815 12.769L9.11345 11.001C8.92581 10.8135 8.67137 10.7082 8.4061 10.7083C8.14083 10.7084 7.88646 10.8138 7.69895 11.0015C7.51144 11.1891 7.40616 11.4436 7.40625 11.7088C7.40634 11.9741 7.51181 12.2285 7.69945 12.416L10.1035 14.82C10.2056 14.9222 10.3269 15.0032 10.4604 15.0586C10.5939 15.1139 10.737 15.1423 10.8815 15.1423C11.0259 15.1423 11.169 15.1139 11.3025 15.0586C11.436 15.0032 11.5573 14.9222 11.6595 14.82L16.5395 9.93897C16.7216 9.75037 16.8224 9.49777 16.8201 9.23557C16.8178 8.97338 16.7127 8.72256 16.5273 8.53716C16.3419 8.35175 16.0911 8.24658 15.8289 8.2443C15.5667 8.24202 15.3141 8.34282 15.1255 8.52497Z"
                                                                fill="#F0FCFF" />
                                                        </svg>
                                                    @else
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5"
                                                            fill="#6b7280" class="bi bi-patch-exclamation-fill"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                        </svg>
                                                    @endif
                                                </p>
                                                <p class="flex gap-2">
                                                    <span class="text-[#EA0A0E]">PNL</span>
                                                    @if ($bot->profit < 0)
                                                        <span class="text-[#EA0A0E] flex space-x-1 flex justify-end">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                            <span>{{ round(($bot->profit / ($bot->capital + 0.0001)) * 100, 2) }}%</span>
                                                        </span>
                                                    @else
                                                        <span class="text-[#00AA39] flex space-x-1 flex justify-end">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                            <span>+{{ round(($bot->profit / ($bot->capital + 0.0001)) * 100, 2) }}%</span>
                                                        </span>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-span-1 text-right flex items-center justify-end mb-3">
                                            <span>{{ formatAmount($bot->balance) }}</span>
                                        </div>
                                    </div>

                                @empty
                                    <p
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Record found!</span>
                                    </p>
                                @endforelse

                            </div>

                        </div>
                    </div>

                </div>

                <!--my recent trades-->
                <div class="col-span-1 p-2 text-white">
                    <p
                        class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] to-[30%] bg-clip-text text-transparent">
                        My Recent trades</p>

                    <div class="lg:border-0 border border-[#3F7DF2] border-opacity-35 rounded-2xl">
                        <div class="w-full lg:border-l lg:border-l-[#3F7DF2] border-opacity-65 rounded-2xl p-6">

                            <div class="w-full h-[75vh] overflow-y-auto px-3">

                                <table class="w-full">
                                    <thead class="text-lg text-[#A8A5AA]">
                                        <th class="font-light px-6 py-2 text-left lg:min-w-52 min-w-[70vw]">AI Bots</th>
                                        <th class="font-light px-6 py-2 text-left lg:min-w-32 min-w-[40vw]">Trading Pairs
                                        </th>
                                        <th class="font-light px-6 py-2 text-right lg:min-w-32 min-w-[40vw]">Profit/Loss
                                        </th>
                                    </thead>
                                    <tbody>
                                        @forelse ($histories as $history)
                                            <tr>
                                                <td class="p-6">
                                                    <div class="flex items-center gap-4 ">
                                                        <img src="{{ asset('storage/bots/' . $history->botActivation->bot->logo) }}"
                                                            alt="bots" width="30px" class="rounded-full">
                                                        <div class="block">
                                                            <p class="text-lg">{{ $history->botActivation->bot->name }}
                                                            </p>
                                                            <p class="text-sm text-[#A8A5AA] flex gap-2">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/ai_clock_icon.svg') }}"
                                                                    alt="clock"><span>{{ date('d-m-y', $history->timestamp) }}</span>
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/ai_calender_icon.svg') }}"
                                                                    alt="clock"><span>{{ date('H:i:s', $history->timestamp) }}</span>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>
                                                @if ($history->profit < 0)
                                                    <td class="text-right p-6">
                                                        <p class="text-md">{{ $history->pair }}</p>

                                                        <p class="text-[#EA0A0E]">
                                                            {{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                        </p>

                                                    </td>
                                                    <td class="text-right p-6">
                                                        <p class="text-md text-[#EA0A0E]">
                                                            {{ formatAmount(str_replace('-', '', $history->profit)) }}</p>
                                                    </td>
                                                @else
                                                    <td class="text-right p-6">
                                                        <p class="text-md">{{ $history->pair }}</p>

                                                        <p class="text-[#00AA39]">
                                                            +{{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                        </p>

                                                    </td>
                                                    <td class="text-right p-6">
                                                        <p class="text-md text-[#00AA39]">
                                                            +{{ formatAmount(str_replace('-', '', $history->profit)) }}</p>
                                                    </td>
                                                @endif
                                            </tr>
                                        @empty
                                            <p
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>Empty Record. No Record found!</span>
                                            </p>
                                        @endforelse
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </section>

    {{-- my history --}}
    <section class="w-full py-6 history" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-5">

            <div class="w-full border-t border-t-[#A320D8] rounded-2xl p-6 lg:flex justify-between items-center mb-3">
                <p
                    class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] lg:to-[70%] to-[10%] bg-clip-text text-transparent">
                    My History</p>
                <div class="flex gap-4 text-white text-sm">
                    <button id="all_history_btn" class="block button_gradient_small">All</button>
                    <button id="withdrawal_history_btn" class="block">Withdrawal</button>
                    <button id="deposit_history_btn" class="block">Deposits</button>
                </div>
            </div>

            <div id="responsiveTable"
                class="w-full border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] rounded-2xl">

                <div id="all_history" class="block overflow-x-auto mb-5">
                    <table class="w-full table-auto smin-w-[800px]">
                        <thead class="text-white">
                            <th class="p-6 text-left font-light lg:min-w-52 min-w-[50vw]">AI Bots/ID</th>
                            <th class="p-6 text-left font-light">Holdings</th>
                            <th class="p-6 text-left font-light">Date</th>
                            <th class="p-6 text-left">Time</th>
                            <th class="p-6 text-left font-light gap-2 relative">
                                <button id="status-dropdown-btn-all"
                                    class="status-dropdown-btn flex gap-3 items-center">Status
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24" style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                        <path
                                            d="M11.178 19.569a.998.998 0 0 0 1.644 0l9-13A.999.999 0 0 0 21 5H3a1.002 1.002 0 0 0-.822 1.569l9 13z">
                                        </path>
                                    </svg>
                                </button>
                                <aside id="status-dropdown-all"
                                    class="status-dropdown hidden absolute bg-[#2d3039] lg:bg-opacity-25 lg:backdrop-blur-md rounded-xl overflow-y-auto h-72">
                                    <ul class="py-4 px-6 text-sm">
                                        <li class="mb-3">
                                            <a href=""
                                                class="block w-40 bg-[#fff] bg-opacity-10 p-2 rounded-lg border-[#fff] border border-opacity-25">
                                                <p class="text-white">All</p>
                                            </a>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#E9790A] bg-opacity-10 p-2 rounded-lg border-[#E9790A] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/yellow-confirming-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#E9790A]">Confirming</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#D8D8D8]">Waiting</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#40DDFF] bg-opacity-10 p-2 rounded-lg border-[#40DDFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-partly-paid-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#40DDFF]">Partly Paid</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-finished-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Finished</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-expire-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Expired</p>
                                                </a>
                                            </div>
                                        </li>


                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Approved</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Rejected</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#309AFF] bg-opacity-10 p-2 rounded-lg border-[#309AFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-duo-icons_approved.svg') }}"
                                                        alt="icon`" class="w-5 h-5">
                                                    <p class="text-[#309AFF]">Pending</p>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </aside>
                            </th>
                        </thead>
                        <tbody>
                            @forelse ($deposits_and_withdrawals as $allData)
                                <tr class="border-b border-opacity-25 border-blue-400 text-white">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img src="{{ 'https://nowpayments.io' . getCurrencyByCoin($allData->deposit_coin_id)->logo_url }}"
                                                alt="coin" width="50px">
                                            <div class="block">
                                                <p class="text-xl">
                                                    {{ getCurrencyByCoin($allData->deposit_coin_id)->name }}</p>
                                                <p class=" text-gray-400">
                                                    {{ $allData->wallet_address ?? $allData->payment_wallet }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="text-lg">{{ formatAmount($allData->amount) }}</p>
                                        <p class=" text-gray-400">
                                            {{ $allData->converted_amount }}
                                            {{ getCurrencyByCoin($allData->deposit_coin_id)->code }}/
                                            <span
                                                class="text-[#EA0A0E]">{{ getCurrencyByCoin($allData->deposit_coin_id)->network ?? getCurrencyByCoin($allData->deposit_coin_id)->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('d-m-y', strtotime($allData->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('H:i:s A', strtotime($allData->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">


                                        @if ($allData->status == 'pending')
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $allData->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($allData->status == 'approved' || $allData->status == 'finished')
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 2.22869C8.92079 1.96354 9.27601 1.80753 9.65088 1.79142C10.0258 1.77532 10.393 1.90029 10.6803 2.14169L10.7763 2.22944L12.2013 3.65369H14.2158C14.5941 3.65376 14.9584 3.79677 15.2357 4.05407C15.5131 4.31136 15.6829 4.66395 15.7113 5.04119L15.7158 5.15369V7.16819L17.1408 8.59319C17.4062 8.85872 17.5623 9.21409 17.5784 9.58914C17.5945 9.96418 17.4694 10.3316 17.2278 10.6189L17.14 10.7142L15.715 12.1392V14.1537C15.7152 14.5321 15.5722 14.8966 15.3149 15.1741C15.0576 15.4516 14.7049 15.6216 14.3275 15.6499L14.2158 15.6537H12.202L10.777 17.0787C10.5115 17.344 10.1561 17.5002 9.7811 17.5163C9.40605 17.5324 9.0386 17.4073 8.7513 17.1657L8.65605 17.0787L7.23105 15.6537H5.2158C4.83737 15.6538 4.47287 15.5109 4.19539 15.2536C3.9179 14.9962 3.74793 14.6436 3.71955 14.2662L3.7158 14.1537V12.1392L2.2908 10.7142C2.02544 10.4487 1.8693 10.0933 1.85319 9.71824C1.83708 9.34319 1.96219 8.97574 2.2038 8.68844L2.2908 8.59319L3.7158 7.16819V5.15369C3.71587 4.77539 3.85888 4.41108 4.11618 4.13375C4.37347 3.85643 4.72606 3.68656 5.1033 3.65819L5.2158 3.65369H7.2303L8.6553 2.22869Z"
                                                            fill="#08C949" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 7.39095L8.84212 10.574L7.51612 9.24795C7.37539 9.10732 7.18456 9.02836 6.9856 9.02843C6.78665 9.0285 6.59588 9.1076 6.45524 9.24833C6.31461 9.38906 6.23565 9.57989 6.23572 9.77884C6.23579 9.9778 6.31489 10.1686 6.45562 10.3092L8.25862 12.1122C8.33523 12.1889 8.4262 12.2497 8.52632 12.2911C8.62644 12.3326 8.73375 12.354 8.84212 12.354C8.95049 12.354 9.0578 12.3326 9.15792 12.2911C9.25804 12.2497 9.34901 12.1889 9.42562 12.1122L13.0856 8.45145C13.2222 8.31 13.2978 8.12055 13.2961 7.9239C13.2944 7.72726 13.2155 7.53915 13.0765 7.40009C12.9374 7.26103 12.7493 7.18216 12.5527 7.18045C12.356 7.17874 12.1666 7.25434 12.0251 7.39095Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#08C949] capitalize">{{ $allData->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($allData->status == 'rejected' || $allData->status == 'failed' || $allData->status == 'refunded')
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="18" viewBox="0 0 19 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 1.57488C8.92079 1.30973 9.27601 1.15372 9.65088 1.13761C10.0258 1.12151 10.393 1.24648 10.6803 1.48788L10.7763 1.57563L12.2013 2.99988H14.2158C14.5941 2.99995 14.9584 3.14296 15.2357 3.40026C15.5131 3.65756 15.6829 4.01014 15.7113 4.38738L15.7158 4.49988V6.51438L17.1408 7.93938C17.4062 8.20491 17.5623 8.56028 17.5784 8.93533C17.5945 9.31037 17.4694 9.67783 17.2278 9.96513L17.14 10.0604L15.715 11.4854V13.4999C15.7152 13.8783 15.5722 14.2428 15.3149 14.5203C15.0576 14.7978 14.7049 14.9677 14.3275 14.9961L14.2158 14.9999H12.202L10.777 16.4249C10.5115 16.6902 10.1561 16.8464 9.7811 16.8625C9.40605 16.8786 9.0386 16.7535 8.7513 16.5119L8.65605 16.4249L7.23105 14.9999H5.2158C4.83737 15 4.47287 14.8571 4.19539 14.5998C3.9179 14.3424 3.74793 13.9897 3.71955 13.6124L3.7158 13.4999V11.4854L2.2908 10.0604C2.02544 9.79485 1.8693 9.43948 1.85319 9.06443C1.83708 8.68938 1.96219 8.32193 2.2038 8.03463L2.2908 7.93938L3.7158 6.51438V4.49988C3.71587 4.12158 3.85888 3.75727 4.11618 3.47994C4.37347 3.20262 4.72606 3.03275 5.1033 3.00438L5.2158 2.99988H7.2303L8.6553 1.57488Z"
                                                            fill="#EA0A0E" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 6.73715L8.84212 9.92015L7.51612 8.59415C7.37539 8.45351 7.18456 8.37455 6.9856 8.37462C6.78665 8.37469 6.59588 8.45379 6.45524 8.59452C6.31461 8.73525 6.23565 8.92608 6.23572 9.12504C6.23579 9.32399 6.31489 9.51476 6.45562 9.6554L8.25862 11.4584C8.33523 11.535 8.4262 11.5958 8.52632 11.6373C8.62644 11.6788 8.73375 11.7002 8.84212 11.7002C8.95049 11.7002 9.0578 11.6788 9.15792 11.6373C9.25804 11.5958 9.34901 11.535 9.42562 11.4584L13.0856 7.79765C13.2222 7.65619 13.2978 7.46674 13.2961 7.27009C13.2944 7.07345 13.2155 6.88534 13.0765 6.74628C12.9374 6.60723 12.7493 6.52835 12.5527 6.52664C12.356 6.52493 12.1666 6.60053 12.0251 6.73715Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#EA0A0E]">{{ $allData->status }}</p>
                                                </div>
                                            </div>
                                        @else
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $allData->status }}</p>
                                                </div>
                                            </div>
                                        @endif

                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Record found!</span>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>

                    </table>
                </div>

                <div id="withdrawal_history" class="hidden overflow-x-auto mb-5">
                    <table class="w-full table-auto">
                        <thead class="text-white">
                            <th class="p-6 text-left font-light lg:min-w-52 min-w-[50vw]">AI Bots/ID</th>
                            <th class="p-6 text-left font-light">Holdings</th>
                            <th class="p-6 text-left font-light">Date</th>
                            <th class="p-6 text-left">Time</th>
                            <th class="p-6 text-left font-light gap-2 relative">
                                <button id="status-dropdown-btn-wth" class="flex gap-3 items-center">Status
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24" style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                        <path
                                            d="M11.178 19.569a.998.998 0 0 0 1.644 0l9-13A.999.999 0 0 0 21 5H3a1.002 1.002 0 0 0-.822 1.569l9 13z">
                                        </path>
                                    </svg>
                                </button>
                                <aside id="status-dropdown-wth"
                                    class="hidden absolute bg-[#2d3039] lg:bg-opacity-25 lg:backdrop-blur-md rounded-xl overflow-y-auto h-72">
                                    <ul class="py-4 px-6 text-sm">
                                        <li class="mb-3">
                                            <a href=""
                                                class="block w-40 bg-[#fff] bg-opacity-10 p-2 rounded-lg border-[#fff] border border-opacity-25">
                                                <p class="text-white">All</p>
                                            </a>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#E9790A] bg-opacity-10 p-2 rounded-lg border-[#E9790A] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/yellow-confirming-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#E9790A]">Confirming</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#D8D8D8]">Waiting</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#40DDFF] bg-opacity-10 p-2 rounded-lg border-[#40DDFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-partly-paid-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#40DDFF]">Partly Paid</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-finished-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Finished</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-expire-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Expired</p>
                                                </a>
                                            </div>
                                        </li>


                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Approved</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Rejected</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#309AFF] bg-opacity-10 p-2 rounded-lg border-[#309AFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-duo-icons_approved.svg') }}"
                                                        alt="icon`" class="w-5 h-5">
                                                    <p class="text-[#309AFF]">Pending</p>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </aside>
                            </th>
                        </thead>
                        <tbody>
                            @forelse ($withdrawals as $withdrawal)
                                <tr class="border-b border-opacity-25 border-blue-400 text-white">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img src="{{ 'https://nowpayments.io' . getCurrencyByCoin($withdrawal->deposit_coin_id)->logo_url }}"
                                                alt="coin" width="50px">
                                            <div class="block">
                                                <p class="text-xl">
                                                    {{ getCurrencyByCoin($withdrawal->deposit_coin_id)->name }}</p>
                                                <p class=" text-gray-400">
                                                    {{ $withdrawal->wallet_address ?? $withdrawal->payment_wallet }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="text-lg">{{ formatAmount($withdrawal->amount) }}</p>
                                        <p class=" text-gray-400">
                                            {{ $withdrawal->converted_amount }}
                                            {{ getCurrencyByCoin($withdrawal->deposit_coin_id)->code }}/
                                            <span
                                                class="text-[#EA0A0E]">{{ getCurrencyByCoin($withdrawal->deposit_coin_id)->network ?? getCurrencyByCoin($withdrawal->deposit_coin_id)->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('d-m-y', strtotime($withdrawal->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('H:i:s A', strtotime($withdrawal->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">


                                        @if ($withdrawal->status == 'pending')
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $withdrawal->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($withdrawal->status == 'approved')
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 2.22869C8.92079 1.96354 9.27601 1.80753 9.65088 1.79142C10.0258 1.77532 10.393 1.90029 10.6803 2.14169L10.7763 2.22944L12.2013 3.65369H14.2158C14.5941 3.65376 14.9584 3.79677 15.2357 4.05407C15.5131 4.31136 15.6829 4.66395 15.7113 5.04119L15.7158 5.15369V7.16819L17.1408 8.59319C17.4062 8.85872 17.5623 9.21409 17.5784 9.58914C17.5945 9.96418 17.4694 10.3316 17.2278 10.6189L17.14 10.7142L15.715 12.1392V14.1537C15.7152 14.5321 15.5722 14.8966 15.3149 15.1741C15.0576 15.4516 14.7049 15.6216 14.3275 15.6499L14.2158 15.6537H12.202L10.777 17.0787C10.5115 17.344 10.1561 17.5002 9.7811 17.5163C9.40605 17.5324 9.0386 17.4073 8.7513 17.1657L8.65605 17.0787L7.23105 15.6537H5.2158C4.83737 15.6538 4.47287 15.5109 4.19539 15.2536C3.9179 14.9962 3.74793 14.6436 3.71955 14.2662L3.7158 14.1537V12.1392L2.2908 10.7142C2.02544 10.4487 1.8693 10.0933 1.85319 9.71824C1.83708 9.34319 1.96219 8.97574 2.2038 8.68844L2.2908 8.59319L3.7158 7.16819V5.15369C3.71587 4.77539 3.85888 4.41108 4.11618 4.13375C4.37347 3.85643 4.72606 3.68656 5.1033 3.65819L5.2158 3.65369H7.2303L8.6553 2.22869Z"
                                                            fill="#08C949" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 7.39095L8.84212 10.574L7.51612 9.24795C7.37539 9.10732 7.18456 9.02836 6.9856 9.02843C6.78665 9.0285 6.59588 9.1076 6.45524 9.24833C6.31461 9.38906 6.23565 9.57989 6.23572 9.77884C6.23579 9.9778 6.31489 10.1686 6.45562 10.3092L8.25862 12.1122C8.33523 12.1889 8.4262 12.2497 8.52632 12.2911C8.62644 12.3326 8.73375 12.354 8.84212 12.354C8.95049 12.354 9.0578 12.3326 9.15792 12.2911C9.25804 12.2497 9.34901 12.1889 9.42562 12.1122L13.0856 8.45145C13.2222 8.31 13.2978 8.12055 13.2961 7.9239C13.2944 7.72726 13.2155 7.53915 13.0765 7.40009C12.9374 7.26103 12.7493 7.18216 12.5527 7.18045C12.356 7.17874 12.1666 7.25434 12.0251 7.39095Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#08C949] capitalize">{{ $withdrawal->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($withdrawal->status == 'rejected' || $withdrawal->status == 'failed' || $withdrawal->status == 'refunded')
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="18" viewBox="0 0 19 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 1.57488C8.92079 1.30973 9.27601 1.15372 9.65088 1.13761C10.0258 1.12151 10.393 1.24648 10.6803 1.48788L10.7763 1.57563L12.2013 2.99988H14.2158C14.5941 2.99995 14.9584 3.14296 15.2357 3.40026C15.5131 3.65756 15.6829 4.01014 15.7113 4.38738L15.7158 4.49988V6.51438L17.1408 7.93938C17.4062 8.20491 17.5623 8.56028 17.5784 8.93533C17.5945 9.31037 17.4694 9.67783 17.2278 9.96513L17.14 10.0604L15.715 11.4854V13.4999C15.7152 13.8783 15.5722 14.2428 15.3149 14.5203C15.0576 14.7978 14.7049 14.9677 14.3275 14.9961L14.2158 14.9999H12.202L10.777 16.4249C10.5115 16.6902 10.1561 16.8464 9.7811 16.8625C9.40605 16.8786 9.0386 16.7535 8.7513 16.5119L8.65605 16.4249L7.23105 14.9999H5.2158C4.83737 15 4.47287 14.8571 4.19539 14.5998C3.9179 14.3424 3.74793 13.9897 3.71955 13.6124L3.7158 13.4999V11.4854L2.2908 10.0604C2.02544 9.79485 1.8693 9.43948 1.85319 9.06443C1.83708 8.68938 1.96219 8.32193 2.2038 8.03463L2.2908 7.93938L3.7158 6.51438V4.49988C3.71587 4.12158 3.85888 3.75727 4.11618 3.47994C4.37347 3.20262 4.72606 3.03275 5.1033 3.00438L5.2158 2.99988H7.2303L8.6553 1.57488Z"
                                                            fill="#EA0A0E" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 6.73715L8.84212 9.92015L7.51612 8.59415C7.37539 8.45351 7.18456 8.37455 6.9856 8.37462C6.78665 8.37469 6.59588 8.45379 6.45524 8.59452C6.31461 8.73525 6.23565 8.92608 6.23572 9.12504C6.23579 9.32399 6.31489 9.51476 6.45562 9.6554L8.25862 11.4584C8.33523 11.535 8.4262 11.5958 8.52632 11.6373C8.62644 11.6788 8.73375 11.7002 8.84212 11.7002C8.95049 11.7002 9.0578 11.6788 9.15792 11.6373C9.25804 11.5958 9.34901 11.535 9.42562 11.4584L13.0856 7.79765C13.2222 7.65619 13.2978 7.46674 13.2961 7.27009C13.2944 7.07345 13.2155 6.88534 13.0765 6.74628C12.9374 6.60723 12.7493 6.52835 12.5527 6.52664C12.356 6.52493 12.1666 6.60053 12.0251 6.73715Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#EA0A0E]">{{ $withdrawal->status }}</p>
                                                </div>
                                            </div>
                                        @else
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $withdrawal->status }}</p>
                                                </div>
                                            </div>
                                        @endif

                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Record found!</span>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>

                    </table>
                </div>

                <div id="deposit_history" class="hidden overflow-x-auto mb-5">
                    <table class="w-full table-auto">
                        <thead class="text-white">
                            <th class="p-6 text-left font-light lg:min-w-52 min-w-[50vw]">AI Bots/ID</th>
                            <th class="p-6 text-left font-light">Holdings</th>
                            <th class="p-6 text-left font-light">Date</th>
                            <th class="p-6 text-left">Time</th>
                            <th class="p-6 text-left font-light gap-2 relative">
                                <button id="status-dropdown-btn-dep"
                                    class="status-dropdown-btn flex gap-3 items-center">Status
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24" style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                        <path
                                            d="M11.178 19.569a.998.998 0 0 0 1.644 0l9-13A.999.999 0 0 0 21 5H3a1.002 1.002 0 0 0-.822 1.569l9 13z">
                                        </path>
                                    </svg>
                                </button>
                                <aside id="status-dropdown-dep"
                                    class="hidden absolute bg-[#2d3039] lg:bg-opacity-25 lg:backdrop-blur-md rounded-xl overflow-y-auto h-72">
                                    <ul class="py-4 px-6 text-sm">
                                        <li class="mb-3">
                                            <a href=""
                                                class="block w-40 bg-[#fff] bg-opacity-10 p-2 rounded-lg border-[#fff] border border-opacity-25">
                                                <p class="text-white">All</p>
                                            </a>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#E9790A] bg-opacity-10 p-2 rounded-lg border-[#E9790A] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/yellow-confirming-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#E9790A]">Confirming</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#D8D8D8]">Waiting</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#40DDFF] bg-opacity-10 p-2 rounded-lg border-[#40DDFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-partly-paid-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#40DDFF]">Partly Paid</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-finished-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Finished</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-expire-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Expired</p>
                                                </a>
                                            </div>
                                        </li>


                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Approved</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-duo-icons_approved.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Rejected</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#309AFF] bg-opacity-10 p-2 rounded-lg border-[#309AFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-duo-icons_approved.svg') }}"
                                                        alt="icon`" class="w-5 h-5">
                                                    <p class="text-[#309AFF]">Pending</p>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </aside>
                            </th>
                        </thead>
                        <tbody>
                            @forelse ($deposits as $deposit)
                                <tr class="border-b border-opacity-25 border-blue-400 text-white">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img src="{{ 'https://nowpayments.io' . getCurrencyByCoin($deposit->deposit_coin_id)->logo_url }}"
                                                alt="coin" width="50px">
                                            <div class="block">
                                                <p class="text-xl">
                                                    {{ getCurrencyByCoin($deposit->deposit_coin_id)->name }}</p>
                                                <p class=" text-gray-400">
                                                    {{ $deposit->wallet_address ?? $deposit->payment_wallet }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="text-lg">{{ formatAmount($deposit->amount) }}</p>
                                        <p class=" text-gray-400">
                                            {{ $deposit->converted_amount }}
                                            {{ getCurrencyByCoin($deposit->deposit_coin_id)->code }}/
                                            <span
                                                class="text-[#EA0A0E]">{{ getCurrencyByCoin($deposit->deposit_coin_id)->network ?? getCurrencyByCoin($deposit->deposit_coin_id)->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('d-m-y', strtotime($deposit->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="">{{ date('H:i:s A', strtotime($deposit->created_at)) }}</p>
                                    </td>
                                    <td class="text-left p-6">


                                        @if ($deposit->status == 'waiting')
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($deposit->status == 'finished')
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 2.22869C8.92079 1.96354 9.27601 1.80753 9.65088 1.79142C10.0258 1.77532 10.393 1.90029 10.6803 2.14169L10.7763 2.22944L12.2013 3.65369H14.2158C14.5941 3.65376 14.9584 3.79677 15.2357 4.05407C15.5131 4.31136 15.6829 4.66395 15.7113 5.04119L15.7158 5.15369V7.16819L17.1408 8.59319C17.4062 8.85872 17.5623 9.21409 17.5784 9.58914C17.5945 9.96418 17.4694 10.3316 17.2278 10.6189L17.14 10.7142L15.715 12.1392V14.1537C15.7152 14.5321 15.5722 14.8966 15.3149 15.1741C15.0576 15.4516 14.7049 15.6216 14.3275 15.6499L14.2158 15.6537H12.202L10.777 17.0787C10.5115 17.344 10.1561 17.5002 9.7811 17.5163C9.40605 17.5324 9.0386 17.4073 8.7513 17.1657L8.65605 17.0787L7.23105 15.6537H5.2158C4.83737 15.6538 4.47287 15.5109 4.19539 15.2536C3.9179 14.9962 3.74793 14.6436 3.71955 14.2662L3.7158 14.1537V12.1392L2.2908 10.7142C2.02544 10.4487 1.8693 10.0933 1.85319 9.71824C1.83708 9.34319 1.96219 8.97574 2.2038 8.68844L2.2908 8.59319L3.7158 7.16819V5.15369C3.71587 4.77539 3.85888 4.41108 4.11618 4.13375C4.37347 3.85643 4.72606 3.68656 5.1033 3.65819L5.2158 3.65369H7.2303L8.6553 2.22869Z"
                                                            fill="#08C949" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 7.39095L8.84212 10.574L7.51612 9.24795C7.37539 9.10732 7.18456 9.02836 6.9856 9.02843C6.78665 9.0285 6.59588 9.1076 6.45524 9.24833C6.31461 9.38906 6.23565 9.57989 6.23572 9.77884C6.23579 9.9778 6.31489 10.1686 6.45562 10.3092L8.25862 12.1122C8.33523 12.1889 8.4262 12.2497 8.52632 12.2911C8.62644 12.3326 8.73375 12.354 8.84212 12.354C8.95049 12.354 9.0578 12.3326 9.15792 12.2911C9.25804 12.2497 9.34901 12.1889 9.42562 12.1122L13.0856 8.45145C13.2222 8.31 13.2978 8.12055 13.2961 7.9239C13.2944 7.72726 13.2155 7.53915 13.0765 7.40009C12.9374 7.26103 12.7493 7.18216 12.5527 7.18045C12.356 7.17874 12.1666 7.25434 12.0251 7.39095Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#08C949] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($deposit->status == 'expired' || $deposit->status == 'failed' || $deposit->status == 'refunded')
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="18" viewBox="0 0 19 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 1.57488C8.92079 1.30973 9.27601 1.15372 9.65088 1.13761C10.0258 1.12151 10.393 1.24648 10.6803 1.48788L10.7763 1.57563L12.2013 2.99988H14.2158C14.5941 2.99995 14.9584 3.14296 15.2357 3.40026C15.5131 3.65756 15.6829 4.01014 15.7113 4.38738L15.7158 4.49988V6.51438L17.1408 7.93938C17.4062 8.20491 17.5623 8.56028 17.5784 8.93533C17.5945 9.31037 17.4694 9.67783 17.2278 9.96513L17.14 10.0604L15.715 11.4854V13.4999C15.7152 13.8783 15.5722 14.2428 15.3149 14.5203C15.0576 14.7978 14.7049 14.9677 14.3275 14.9961L14.2158 14.9999H12.202L10.777 16.4249C10.5115 16.6902 10.1561 16.8464 9.7811 16.8625C9.40605 16.8786 9.0386 16.7535 8.7513 16.5119L8.65605 16.4249L7.23105 14.9999H5.2158C4.83737 15 4.47287 14.8571 4.19539 14.5998C3.9179 14.3424 3.74793 13.9897 3.71955 13.6124L3.7158 13.4999V11.4854L2.2908 10.0604C2.02544 9.79485 1.8693 9.43948 1.85319 9.06443C1.83708 8.68938 1.96219 8.32193 2.2038 8.03463L2.2908 7.93938L3.7158 6.51438V4.49988C3.71587 4.12158 3.85888 3.75727 4.11618 3.47994C4.37347 3.20262 4.72606 3.03275 5.1033 3.00438L5.2158 2.99988H7.2303L8.6553 1.57488Z"
                                                            fill="#EA0A0E" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 6.73715L8.84212 9.92015L7.51612 8.59415C7.37539 8.45351 7.18456 8.37455 6.9856 8.37462C6.78665 8.37469 6.59588 8.45379 6.45524 8.59452C6.31461 8.73525 6.23565 8.92608 6.23572 9.12504C6.23579 9.32399 6.31489 9.51476 6.45562 9.6554L8.25862 11.4584C8.33523 11.535 8.4262 11.5958 8.52632 11.6373C8.62644 11.6788 8.73375 11.7002 8.84212 11.7002C8.95049 11.7002 9.0578 11.6788 9.15792 11.6373C9.25804 11.5958 9.34901 11.535 9.42562 11.4584L13.0856 7.79765C13.2222 7.65619 13.2978 7.46674 13.2961 7.27009C13.2944 7.07345 13.2155 6.88534 13.0765 6.74628C12.9374 6.60723 12.7493 6.52835 12.5527 6.52664C12.356 6.52493 12.1666 6.60053 12.0251 6.73715Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#EA0A0E]">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @else
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @endif

                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Record found!</span>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>

                    </table>
                </div>

            </div>


        </div>
    </section>
@endsection

@section('scripts')
    <script>
        var lineChartData = {
            labels: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
            datasets: [{
                    label: "Profit",
                    data: @json($profits),
                    pointBackgroundColor: "rgba(16,133,135,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(16,133,135,1)",
                    tension: 0.4,
                    fill: true,
                },
                {
                    label: "Deposit",
                    data: @json($deposits_graph).reverse(),
                    pointBackgroundColor: "rgba(255,100,50,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(255,100,50,1)",
                    tension: 0.4,
                    fill: true,
                },
                {
                    label: "Withdrawal",
                    data: @json($withdrawals_graph).reverse(),
                    pointBackgroundColor: "rgba(50,150,255,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(50,150,255,1)",
                    tension: 0.4,
                    fill: true,
                }
            ],
        };

        window.addEventListener("load", function() {
            var canvas = document.getElementById("canvas");
            if (!canvas) {
                console.error("Canvas element not found!");
                return;
            }

            var ctx = canvas.getContext("2d");
            var currentDay = new Date().getDay(); // Get the current day (0 = Sunday, 6 = Saturday)

            // Rearrange the labels from right to left starting with today
            function rearrangeLabelsRightToLeft(labels, currentDay) {
                // Create a reversed copy of the original labels
                const reversedLabels = [...labels].reverse();

                // Rotate the array so it starts with the current day
                const rotatedLabels = [
                    ...reversedLabels.slice(currentDay),
                    ...reversedLabels.slice(0, currentDay)
                ];

                // Reverse back to maintain the right-to-left order
                return rotatedLabels.reverse();
            }

            // Rearrange datasets to match the new label order
            function rearrangeDatasets(datasets, currentDay) {
                return datasets.map(dataset => ({
                    ...dataset,
                    data: [
                        ...dataset.data.slice(currentDay).reverse(),
                        ...dataset.data.slice(0, currentDay).reverse()
                    ]
                }));
            }

            // Update both labels and datasets
            const rearrangedLabels = rearrangeLabelsRightToLeft(lineChartData.labels, currentDay);
            const rearrangedDatasets = rearrangeDatasets(lineChartData.datasets, currentDay);

            var chart = new Chart(ctx, {
                type: "line",
                data: {
                    labels: rearrangedLabels,
                    datasets: rearrangedDatasets
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1000,
                                color: "#747474"
                            },
                        },
                        x: {
                            ticks: {
                                color: "#C688FA"
                            }
                        },
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: "top"
                        },
                        tooltip: {
                            callbacks: {
                                title: function(tooltipItem) {
                                    return `Day: ${tooltipItem[0].label}`;
                                },
                                label: function(tooltipItem) {
                                    return `${tooltipItem.dataset.label}: ${tooltipItem.raw} {{ site('currency') }}`;
                                },
                            },
                        },
                    },
                    animation: {
                        onComplete: function() {
                            rearrangedDatasets.forEach((dataset, i) => {
                                dataset.backgroundColor = ctx.createLinearGradient(0, 0, 0,
                                    canvas.height);
                                dataset.backgroundColor.addColorStop(0, dataset.borderColor);
                                dataset.backgroundColor.addColorStop(1, "rgba(0,0,0,0)");
                            });
                            chart.update();
                        },
                    },
                },
            });
        });
    </script>

    <!-- jQuery Script for Sidebar Toggle and right dropdown-->
    <script>
        $(document).ready(function() {
            $("#all_history_btn").on("click", function() {
                $("#all_history").slideDown().removeClass('hidden');
                $("#withdrawal_history, #deposit_history").slideUp().addClass('hidden');

                $("#withdrawal_history_btn, #deposit_history_btn").removeClass('button_gradient_small');
                $("#all_history_btn").addClass('button_gradient_small');
            });

            $("#withdrawal_history_btn").on("click", function() {
                $("#withdrawal_history").slideDown().removeClass('hidden');
                $("#all_history, #deposit_history").slideUp().addClass('hidden');

                $("#all_history_btn, #deposit_history_btn").removeClass('button_gradient_small');
                $("#withdrawal_history_btn").addClass('button_gradient_small');
            });

            $("#deposit_history_btn").on("click", function() {
                $("#deposit_history").slideDown().removeClass('hidden');
                $("#all_history, #withdrawal_history").slideUp().addClass('hidden');

                $("#withdrawal_history_btn, #all_history_btn").removeClass('button_gradient_small');
                $("#deposit_history_btn").addClass('button_gradient_small');
            });
        });

        $(document).ready(function() {
            // Toggle status dropdown visibility
            $('#status-dropdown-btn-all').click(function() {
                $('#status-dropdown-all').toggleClass('hidden');
            });

            $('#status-dropdown-btn-wth').click(function() {
                $('#status-dropdown-wth').toggleClass('hidden');
            });

            $('#status-dropdown-btn-dep').click(function() {
                $('#status-dropdown-dep').toggleClass('hidden');
            });
        });
    </script>
@endsection
