@extends('templates.' . site('template') . '.layouts.user')

@section('css')
@endsection

@section('contents')
    <!--my profile-->
    <div class="w-full py-6" id="refresh">


        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">

                <div class="lg:flex gap-4 justify-between items-center px-3">
                    <div class="block mb-5">
                        <p class="text-xl lg:text-2xl font-bold mb-6 text-white">Edit Profile</p>
                        <div class="flex gap-4 text-white text-sm">
                            <button id="editProfileBtn" class="block ai_button_gradient_small">Edit Profile</button>
                            <button id="securityBtn" class="block">Security</button>
                        </div>
                    </div>
                    <div class="bl">
                        <button id="saveChangesBtn"
                            class="lg:w-60 border rounded-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">Save
                            Changes</button>
                    </div>
                </div>

            </div>
        </section>

        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">


                <!--edit my profile -->
                <div id="editProfile" class="mb-10">
                    <div class="w-full border-t border-t-[#A320D8]  rounded-2xl lg:p-6">

                        <div class="w-full p-4 lg:px-10 mb-10 text-white">
                            <div class="flex justify-between items-center mb-10">
                                <p class="">Update Profile Information</p>
                            </div>

                            <!------edit-->
                            <div class="lg:flex gap-6 items-center justify-center">
                                <div class="block text-center mb-6 lg:w-[300px]">

                                    <form action="{{ route('user.profile.photo') }}" method="POST"
                                        enctype="multipart/form-data" class="mt-5 gen-form">
                                        @csrf

                                        <!-- Profile Image -->
                                        <img id="profileImage" src="{{ asset('storage/profile/' . user()->photo) }}"
                                            alt="Profile Photo" class="w-[200px] h-[200px] mb-4 mx-auto rounded-full">

                                        <!-- Hidden File Input -->
                                        <input type="file" name="photo" id="profile_photo" accept="image/*" hidden>

                                        <div class="flex gap-2 justify-center">
                                            <!-- Edit Button (Triggers File Input) -->
                                            <button type="button" id="selectProfilePhoto">
                                                <label
                                                    class="flex gap-2 justify-center mx-auto text-end rounded-full bg-white bg-opacity-15 
                                                          py-1 px-6 text-sm cursor-pointer">

                                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                                        viewBox="0 0 25 25" fill="none">
                                                        <path
                                                            d="M15.5667 6.73308L18.5667 9.73308M13.5667 20.7331H21.5667M5.56665 16.7331L4.56665 20.7331L8.56665 19.7331L20.1527 8.14708C20.5276 7.77203 20.7382 7.26341 20.7382 6.73308C20.7382 6.20276 20.5276 5.69414 20.1527 5.31908L19.9806 5.14708C19.6056 4.77214 19.097 4.56151 18.5667 4.56151C18.0363 4.56151 17.5277 4.77214 17.1527 5.14708L5.56665 16.7331Z"
                                                            stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>

                                                    <span class="text-white">Edit</span>
                                                </label>
                                            </button>

                                            <!-- Save Button (Initially Hidden) -->
                                            <button type="submit"
                                                class="hidden mx-auto text-end rounded-full bg-[#60A4F6] py-1 px-6 text-sm">
                                                <span class="text-white">Save</span>
                                            </button>
                                        </div>
                                    </form>

                                </div>

                                <div class="block w-full">

                                    <form action="{{ route('user.profile.edit-validate') }}" class="mt-5 gen-form">
                                        @csrf

                                        <div class="w-full mb-10">
                                            <div
                                                class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                <label class="text-white text-sm p-2">Name {!! is_required('name') !!}</label>
                                                <div class="w-full">
                                                    <input type="text" name="name" id="name"
                                                        placeholder="Enter Fullname"
                                                        value="{{ old('name') ?? user()->name }}" {!! is_required('name', false) !!}
                                                        class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1">
                                                </div>

                                                <span class="text-sm text-[#EA0A0E]">
                                                    @error('name')
                                                        {{ $message }}
                                                    @enderror
                                                </span>
                                            </div>
                                        </div>

                                        <div class="w-full mb-10">
                                            <div
                                                class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                <label class="text-white text-sm p-2">Email {!! is_required('email') !!}</label>
                                                <div class="w-full">
                                                    <input type="email" name="email" id="email"
                                                        class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                        placeholder="user@user.com"
                                                        value="{{ old('email') ?? user()->email }}" disabled
                                                        {!! is_required('email', false) !!}>
                                                </div>

                                                <span class="text-sm text-[#EA0A0E]">
                                                    @error('email')
                                                        {{ $message }}
                                                    @enderror
                                                </span>
                                            </div>
                                        </div>

                                        <div class="w-full mb-10">
                                            <div
                                                class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                <label class="text-white text-sm p-2">Phone Number
                                                    {!! is_required('phone') !!}</label>
                                                <div class="w-full">
                                                    <input type="number" name="phone" id="phone"
                                                        class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                        placeholder="4494895984" value="{{ old('phone') ?? user()->phone }}"
                                                        {!! is_required('phone', false) !!}>
                                                </div>

                                                <span class="text-sm text-[#EA0A0E]">
                                                    @error('phone')
                                                        {{ $message }}
                                                    @enderror
                                                </span>
                                            </div>
                                        </div>

                                        <div class="w-full mb-10">
                                            <div
                                                class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                <label class="text-white text-sm p-2">Username
                                                    {!! is_required('username') !!}</label>
                                                <div class="w-full">
                                                    <input type="text" name="username" id="username"
                                                        class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                        placeholder="username"
                                                        value="{{ old('username') ?? user()->username }}"
                                                        @if (user()->username) disabled @endif
                                                        {!! is_required('username', false) !!}>
                                                </div>

                                                <span class="text-sm text-[#EA0A0E]">
                                                    @error('username')
                                                        {{ $message }}
                                                    @enderror
                                                </span>
                                            </div>
                                        </div>

                                        <div class="lg:grid grid-cols-3 gap-6">

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Address
                                                        {!! is_required('address') !!}</label>
                                                    <div class="w-full">
                                                        <input type="text" name="address" id="address"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="City Addresss"
                                                            value="{{ old('address') ?? user()->address }}"
                                                            {!! is_required('address', false) !!}>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('address')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">City
                                                        {!! is_required('city') !!}</label>
                                                    <div class="w-full">
                                                        <input type="text" name="city" id="city"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="City" value="{{ old('city') ?? user()->city }}"
                                                            {!! is_required('city', false) !!}>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('city')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Country
                                                        {!! is_required('country') !!}</label>
                                                    <div class="w-full">
                                                        <select name="country" id="country"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1 custom-select"
                                                            {!! is_required('country', false) !!}>

                                                            <option disabled
                                                                @if (!old('country') || !user()->country) selected @endif>
                                                                Select Country
                                                            </option>
                                                            @foreach (countries() as $country)
                                                                <option value="{{ $country->english_name }}"
                                                                    @if (old('country') ?? user()->country == $country->english_name) selected @endif>
                                                                    {{ $country->english_name }}</option>
                                                            @endforeach

                                                        </select>

                                                        <span class="text-sm text-[#EA0A0E]">
                                                            @error('country')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">State
                                                        {!! is_required('state') !!}</label>
                                                    <div class="w-full">
                                                        <input type="text" name="state" id="state"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="State"
                                                            value="{{ old('state') ?? user()->state }}"
                                                            {!! is_required('state', false) !!}>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('state')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Date of Birth
                                                        {!! is_required('dob') !!}</label>
                                                    <div class="w-full">
                                                        <input type="date" name="dob" id="dob"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="12/07/2025"
                                                            value="{{ old('dob') ?? user()->dob }}"
                                                            {!! is_required('dob', false) !!}>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('dob')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Gender
                                                        {!! is_required('gender') !!}</label>
                                                    <div class="w-full">
                                                        <select name="gender" placeholder="Gender" id="gender"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1 custom-select"
                                                            {!! is_required('gender', false) !!}>
                                                            <option disabled
                                                                @if (!old('gender') || !user()->gender) selected @endif>
                                                                Select Gender
                                                            </option>
                                                            <option value="male"
                                                                @if (old('gender') ?? user()->gender == 'male') selected @endif>Male
                                                            </option>
                                                            <option value="female"
                                                                @if (old('gender') ?? user()->gender == 'female') selected @endif>Female
                                                            </option>
                                                            <option value="neutral"
                                                                @if (old('gender') ?? user()->gender == 'neutral') selected @endif>Neutral
                                                            </option>
                                                        </select>

                                                        <span class="text-sm text-[#EA0A0E]">
                                                            @error('gender')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <button type="submit" id="submitUpdateBtn" class="text-blue-500"></button>

                                    </form>

                                </div>

                            </div>

                        </div>
                    </div>

                </div>

                <!--edit profile-security-->
                <div id="editProfileSecurity" class="hidden">
                    <div class="lg:flex gap-16 items-center">

                        <div id="password_update"
                            class="block mb-6 w-full relative  border-t border-t-[#A320D8]  rounded-2xl">

                            <form action="{{ route('user.profile.password') }}"
                                class="relative flex flex-col h-full gen-form">
                                @csrf

                                <div class="flex-grow mb-10 lg:p-6">
                                    <div class="w-full p-4 lg:px-10">
                                        <div class="flex justify-between items-center mb-10">
                                            <p class="text-white">Update Password</p>
                                        </div>

                                        <div class="block w-full">
                                            <!-- Current Password -->
                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#A320D8] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Current Password</label>
                                                    <div class="w-full">
                                                        <input type="password" name="current_password"
                                                            id="current_password"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="Input Old Password" required>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('current_password')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <!-- New Password -->
                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#A320D8] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">New Password</label>
                                                    <div class="w-full">
                                                        <input type="password" name="password" id="password"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="Input New Password" required>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('password')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                            <!-- Confirm Password -->
                                            <div class="w-full mb-10">
                                                <div
                                                    class="w-full text-white border border-[#A320D8] border-opacity-30 rounded-lg p-3">
                                                    <label class="text-white text-sm p-2">Confirm Password</label>
                                                    <div class="w-full">
                                                        <input type="password" name="password_confirmation"
                                                            id="password_confirmation"
                                                            class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                            placeholder="Confirm Password" required>
                                                    </div>

                                                    <span class="text-sm text-[#EA0A0E]">
                                                        @error('password_confirmation')
                                                            {{ $message }}
                                                        @enderror
                                                    </span>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <!-- Save Changes Button -->
                                <button type="submit"
                                    class="h-14 mt-auto w-full p-2 border rounded-b-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">
                                    Save Changes
                                </button>
                            </form>
                        </div>

                        @if (user()->g2fa == 0)
                            <div id="enable_2fa_update"
                                class="block mb-6 w-full relative  border-t border-t-[#95E3FD]  rounded-2xl">
                                <div class="block">
                                    <form action="{{ route('user.profile.g2fa') }}" class="relative h-full gen-form"
                                        data-action="reload">
                                        @csrf

                                        <div class="w-full p-4 lg:px-10 rounded-2xl">
                                            <div class="flex justify-between items-center">
                                                <p class="text-white py-10">Enable 2FA</p>
                                            </div>

                                            <div class="block w-full py-6">

                                                <div class="flex w-full justify-center mb-10">
                                                    <div class="bg-blue-100 rounded-xl bg-opacity-20 p-2">
                                                        <div id="wallet_qrcode" class="clipboard" data-copy=""></div>
                                                    </div>
                                                </div>

                                                <div class="w-full py-4">
                                                    <div
                                                        class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                        <label class="text-white text-sm p-2">2FA Code *</label>
                                                        <div class="w-full">
                                                            <input type="text" name="one_time_password"
                                                                id="one_time_password"
                                                                class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                                placeholder="Input here" required>
                                                        </div>

                                                        <span class="text-sm text-[#EA0A0E]">
                                                            @error('one_time_password')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>

                                                <div class="w-full mb-4 text-center">
                                                    <p class="text-white text-sm mb-3">Scan the QRCode above or copy the
                                                        2FA
                                                        Code below to set up your 2fa</p>
                                                    <p
                                                        class="text-right text-gray-400 flex justify-center gap-3 items-center overflow-hidden copy-icon">
                                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}"
                                                            alt="icon" class="copy-icon clipboard"
                                                            data-copy="{{ user()->g2fa_secret }}"
                                                            style="cursor: pointer;">
                                                        <span id="2fa_code"
                                                            class="lg:text-lg">{{ user()->g2fa_secret }}</span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="w-full text-white">
                                            <button class="h-14 w-full p-2 border border-[#95E3FD] rounded-b-full">Save
                                                Changes</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        @else
                            <div id="disable_2fa_update"
                                class="block mb-6 w-full relative  border-t border-t-[#95E3FD]  rounded-2xl">
                                <div class="block">
                                    <form action="{{ route('user.profile.g2fa') }}" class="relative h-full gen-form"
                                        data-action="reload">
                                        @csrf

                                        <div class="w-full p-4 lg:px-10 rounded-2xl mb-10">
                                            <div class="flex justify-between items-center mb-10">
                                                <p class="text-white py-4">2FA</p>
                                            </div>

                                            <div class="block w-full">
                                                <div class="w-full py-4">
                                                    <div
                                                        class="w-full text-white border border-[#95E3FD] border-opacity-30 rounded-lg p-3">
                                                        <label class="text-white text-sm p-2">2FA *</label>
                                                        <div class="w-full">
                                                            <input type="text" name="one_time_password"
                                                                id="one_time_password"
                                                                class="w-full p-2 bg-transparent text-[#D8D8D8] border-0 focus:outline-none flex-1"
                                                                placeholder="Input here" required>
                                                        </div>

                                                        <span class="text-sm text-[#EA0A0E]">
                                                            @error('one_time_password')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>

                                                <p class="text-white text-sm mb-3 text-center">Enter the One time passcode
                                                    from your
                                                    google authenticator app to disable your g2fa</p>
                                            </div>

                                        </div>

                                        <div class="w-full text-white">
                                            <button type="submit"
                                                class="h-14 w-full p-2 border border-[#95E3FD] rounded-b-full">Disable
                                                2FA</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

        </section>
    </div>
    <!--end my profile-->
@endsection

@section('scripts')
    @if (user()->g2fa == 0)
        <script>
            $(document).ready(function() {
                // create qrcode
                var qrCodeElement = document.getElementById('wallet_qrcode');
                var text = "{{ $qr_code_url }}";
                var qrCode = new QRCode(qrCodeElement, {
                    text: text,
                    width: 200,
                    height: 200
                });

                var walletQrCodeDiv = document.getElementById('wallet_qrcode');
                walletQrCodeDiv.classList.add('disabled');
                var imageElement = walletQrCodeDiv.querySelector('img');
                imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                    'hover:border-slate-600', 'cursor-pointer', 'p-1');
            });
        </script>
    @endif

    <script>
        function initializeProfileTabs() {
            //console.log("Profile Tabs Initialized");

            // Handle Profile Tab Click
            $(document).off("click", "#editProfileBtn").on("click", "#editProfileBtn", function() {
                $("#editProfile").slideDown().removeClass('hidden');
                $("#editProfileSecurity").slideUp().addClass('hidden');

                $("#saveChangesBtn").slideDown().removeClass('hidden');

                $("#securityBtn").removeClass('ai_button_gradient_small');
                $("#editProfileBtn").addClass('ai_button_gradient_small');
            });

            // Handle Security Tab Click
            $(document).off("click", "#securityBtn").on("click", "#securityBtn", function() {
                $("#editProfileSecurity").slideDown().removeClass('hidden');
                $("#editProfile").slideUp().addClass('hidden');

                $("#saveChangesBtn").slideUp().addClass('hidden');

                $("#editProfileBtn").removeClass('ai_button_gradient_small');
                $("#securityBtn").addClass('ai_button_gradient_small');
            });
        }

        // Run profile tab initialization on page load
        $(document).ready(function() {
            initializeProfileTabs();
        });

        //////////// submit update
        $(document).on("click", "#saveChangesBtn", function() {
            $("#submitUpdateBtn").trigger("click"); // Triggers the submit button programmatically
        });
    </script>

    <script>
        $(document).ready(function() {

            let isVisible = false; // Track visibility state

            var status = 200;
            if (status == 200) {
                if (isVisible) {
                    $('#notification').hide();
                } else {
                    $('#notification').show();
                    setTimeout(function() {
                        $('#notification').hide();
                        isVisible = false; // Reset visibility state
                    }, 2000); // Hide after 3 seconds
                }
                isVisible = !isVisible;
                //////////////////////////////
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            // Open file input when clicking on the "Edit" button
            $("#selectProfilePhoto").on("click", function() {
                $("#profile_photo").trigger("click");
            });

            // When a new file is selected, update the profile image preview
            $("#profile_photo").on("change", function(event) {
                var input = event.target;

                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $("#profileImage").attr("src", e.target.result); // Update image preview
                        $("button[type='submit']").removeClass("hidden").fadeIn(); // Show Save button
                    };

                    reader.readAsDataURL(input.files[0]); // Read the selected image
                }
            });
        });
    </script>
@endsection
