@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    
<section class="lg:w-full w-screen py-6"  data-aos="fade-up">
    <div class="max-w-screen-2xl mx-auto mb-5">

    <div class="flex gap-4 justify-between items-center px-3">
      <p class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] lg:to-[70%] to-[50%] bg-clip-text text-transparent">My Referrals</p>
    </div>

    </div>
  </section>

  <section class="lg:w-full w-screen py-6"  data-aos="fade-up">
    <div class="max-w-screen-2xl mx-auto mb-5">


      <!--my direct referral -->
      <div id="myDirectReferral" class="mb-10">
        <div class="w-full border-t border-t-[#60A4F6]  rounded-2xl p-6">
          <div class="lg:flex justify-between items-center">
            <p class="text-white mb-5">Direct Referrals</p>
            <p class="text-gray-400 flex gap-3 items-center mb-5">
              <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}" alt="icon" class="clipboard"
              data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}" style="cursor: pointer;">
              <span data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}" class="lg:text-md text-[12px] clipboard">
                {{ route('user.register', ['ref' => user()->username ?? 'notset']) }}
              </span>
            </p>
          </div>
          <div class="flex justify-center items-center">
            <p class="font-light text-[128px] p-0 m-0 leading-none bg-gradient-to-tl from-white  from-30% via-slate-600 via-50% to-white to-80% bg-clip-text text-transparent">{{ user()->referredUsers->count() }}</p>
          </div>
        </div>
      </div>


      @php
        function displayReferralTree($user, $level = 0, $maxLevels = 10)
        {
            if ($level >= $maxLevels) {
                return;
            }
        
            $referredUsers = $user->referredUsers;
        
            if ($referredUsers->count() > 0) {
                echo '';
                foreach ($referredUsers as $referredUser) {
                    echo '<tr class="py-2 text-sm"><td class="p-2 py-2"><p class="px-4 py-4 bg-blue-200 bg-opacity-15" style="margin-left:' . 40 * $level . 'px">' . $referredUser->username . '</p></td></tr>';
                    displayReferralTree($referredUser, $level + 1, $maxLevels);
                }
                echo ' ';
            }
        }
    @endphp

      <!--my referral history-->
      <div id="myReferralHistory" class="mb-10">
        <div class="w-full border-t border-t-[#A320D8]  rounded-2xl lg:px-6">
        
          <div id="all_history" class="block overflow-x-auto mb-5 text-white">
            <table class="w-full">
              <thead class="text-center">
                <th class="p-6 text-left">My referral Tree</th>
              </thead>
              <tbody>

                @php
                    displayReferralTree(user());
                @endphp
                
              </tbody>
            </table>
          </div>

        </div> 
      </div>

    </div>
  </section>

@endsection
