@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    {{-- search form --}}
    <div class="mx-auto py-10">
        <!--search form-->
        <div action="" class="block lg:w-[50%] mx-auto" id="filterForm">
            <div class="w-full flex border rounded-full">
                <input type="text" placeholder="Txn ref" id="search-transaction-input" value="{{ request()->s }}"
                    class="py-3 h-14s px-6 rounded-l-full bg-transparent w-full text-white">

                <div class="simple-pagination" data-paginator="transactions">
                    <a id="search-transaction-button" data-link="{{ route('user.transactions.index') }}" href=""
                        class="paginator-link flex gap-4 items-center bg-gradient-to-tr from-[#95E3FD] to-[#A320D8] t-[40%] py-3 px-8 rounded-r-full text-white">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-icons_search-outline.svg') }}"
                            alt="icon">
                        <span>Search</span>
                    </a>
                </div>
            </div>
        </div>
    </div>


    <!--my transaction-->
    <div class="w-full py-6" id="pageContent">


        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">

                <div class="flex gap-4 justify-between items-center px-3">
                    <p
                        class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-blue-500 via-blue-400 to-purple-600 bg-clip-text text-transparent">
                        Transactions</p>
                </div>

            </div>
        </section>

        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">


                <!--my direct referral -->
                <div id="myDirectReferral" class="mb-10">
                    <div class="w-full border-t border-t-[#60A4F6]  rounded-2xl p-6">
                        <div class="lg:flex justify-between items-center">
                            <p class="text-white mb-5">Total Transaction</p>
                        </div>
                        <div class="text-center text-white">
                            <p
                                class="text-[74px] p-0 m-0 leading-none bg-gradient-to-r from-[#3F7DF2] from-[40%] via-[#95E3FD] via-[50%] to-[#A320D8] to-[60%] bg-clip-text text-transparent">
                                {{ $transactions->total() }}
                            </p>
                            <p class="p-0 m-0 leading-none">Transactions made</p>
                        </div>
                    </div>
                </div>



                <!--my transaction history-->
                <div id="myTransactionHistory" class="mb-10">
                    <div class="w-full border-t border-t-[#A320D8]  rounded-2xl lg:px-6" id="transactions">

                        <div id="all_history" class="block overflow-x-auto mb-5 text-white h-[70vh]">
                            <table class="w-full table-auto" id="transactionsTable">
                                <thead class="text-left">
                                    <th class="p-6 lg:min-w-32 min-w-[50vw] font-light">Date/Time</th>
                                    <th class="p- lg:min-w-32 min-w-[50vw] font-light">Description</th>
                                    <th class="p-2 lg:min-w-32 min-w-[50vw] font-light">Ref</th>
                                    <th class="p-2 lg:min-w-32 min-w-[30vw] font-light">Amount</th>
                                    <th class="p-2 lg:min-w-32 min-w-[20vw] font-light"></th>
                                </thead>
                                <tbody class="text-sm">
                                    @forelse ($transactions as $transaction)
                                        <tr class="border-b border-opacity-25 border-blue-200 py-6">
                                            <td class="py-6 px-4">
                                                <p>{{ date('d-m-y H:i:s', strtotime($transaction->created_at)) }}</p>
                                            </td>
                                            <td class="py-6">
                                                <p class="cursor-pointer" data-copy="{{ $transaction->description }}">
                                                    {{ $transaction->description }}</p>
                                            </td>
                                            <td class="py-6" data-transaction_tnx="{{ $transaction->ref }}">
                                                <p class="clipboard cursor-pointer" data-copy="{{ $transaction->ref }}">
                                                    {{ $transaction->ref }}</p>
                                            </td>
                                            <td class="py-6">
                                                <p>{{ formatAmount($transaction->amount) }}</p>
                                            </td>
                                            <td class="py-6 flex justify-end px-4">
                                                @if ($transaction->type == 'debit')
                                                    <span
                                                        class="text-end rounded-full w-auto bg-[#EA0A0E] bg-opacity-15 py-1 px-3 text-sm text-[#EA0A0E]">{{ $transaction->type }}</span>
                                                @else
                                                    <span
                                                        class="text-end rounded-full w-auto bg-[#08C949] bg-opacity-15 py-1 px-3 text-sm text-[#08C949]">{{ $transaction->type }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>Empty Record!</span>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="cursor-pointer simple-pagination" data-paginator="transactions">
                            {{ $transactions->links('templates.' . site('template') . '.paginations.simple') }}
                        </div>

                    </div>
                </div>

            </div>
        </section>


    </div>
    <!--end my transaction-->
@endsection

@section('scripts')
    <script>
        // search transaction
        $(document).on('input keyup', '#search-transaction-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-transaction-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-transaction-button').attr('href', link);
        });
    </script>
@endsection
