<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <title>{{ site('name') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">


    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap');

        * {
            font-family: 'Poppins';
        }

        body.bg-dark {
            background-color: #010510;
            padding: 1.5rem;
        }

        ul {
            list-style: none;
            padding: 0;
            /* Optional: Removes default padding */
            margin: 0;
            /* Optional: Removes default margin */
        }

        .container {
            width: 100%;
            overflow: auto;
            padding: 0.75rem 3rem;
        }

        .email-content {
            max-width: 1280px;
            background-color: white;
            margin: 0px auto;
        }

        .header {
            height: 20rem;
            background-color: #EEC6FF;
            display: flex;
            align-items: center;
            position: relative;
        }

        .header img {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
        }

        .body-content {
            padding: 1.25rem 5rem;
            margin: 7rem 0px;
        }

        .text-content p {
            padding-top: 1.25rem;
            padding-bottom: 1.25rem;
            text-align: justify;
        }

        .footer {
            width: 100%;
            padding-top: 2.5rem;
            padding-bottom: 2.5rem;
        }

        .contact-info {
            max-width: 1024px;
            margin: 0 auto;
            border-radius: 0.75rem;
            padding: 0.5rem;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1rem;
            padding-top: 2.5rem;
            padding-bottom: 2.5rem;
            width: 100%;

        }

        .contact-item {
            display: flex;
            gap: 0.75rem;
            align-items: center;
            color: #0040BC;
        }

        .contact-item img {
            padding: 0.75rem;
            background-color: rgba(255, 255, 255, 0.15);
            border-radius: 50%;
        }

        .contact-item.full-width {
            grid-column: span 2;
        }

        .unsubscribe {
            padding: 2rem 0px;
            text-align: center;
            margin-bottom: 2.5rem;
        }

        .unsubscribe a {
            color: #B4B1B1;
            text-decoration: underline;
        }

        .social-icons {
            display: flex;
            justify-content: center;
            gap: 1rem;
        }

        .social-icon {
            padding: 0.5rem;
            background-color: rgba(227, 157, 255, 0.25);
            border-radius: 0.5rem;
        }

        .emaiIcon {
            width: 4rem;
        }

        .logo {
            min-width: 25rem;
            margin: 0px auto;
            min-height: 10rem;
        }

        .header-content {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            /* Centers items vertically */
        }



        /* Tablet Breakpoint (768px to 1023px) */
        @media screen and (max-width: 1023px) {

            body.bg-dark {
                background-color: #010510;
                padding: 0px;
            }

            .container {
                padding: 0.75rem 1.5rem;
                margin: 0px auto;
            }

            .email-content {
                width: 700px;
                background-color: white;
            }

            .body-content {
                padding: 1.25rem 2.5rem;
                margin: 4rem 0px;
            }

            .contact-grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .contact-item.full-width {
                grid-column: span 1;
            }

            .header {
                height: 16rem;
            }

            .header img {
                width: 80%;
            }

            .emaiIcon {
                width: 3rem;
            }

            .contact-info {
                max-width: 600px;
                margin: 0 auto;
                border-radius: 0.75rem;
                padding: 1.5rem;
            }
        }

        /* Mobile Breakpoint (below 768px) */
        @media screen and (max-width: 767px) {


            .contact-info {
                max-width: 100%;
                margin: 0 auto;
                border-radius: 0.75rem;
                padding: 1.5rem;
            }

            body.bg-dark {
                background-color: #010510;
                padding: 0px;
            }

            .container {
                padding: 0px;
                margin: 0px auto;
                width: 100%;
            }

            .email-content {
                width: 370px;
                padding: 0;
            }

            .body-content {
                padding: 1rem;
                margin: 2rem 0px;
            }

            .contact-grid {
                grid-template-columns: 1fr;
                gap: 1.25rem;
                padding-top: 1.5rem;
                padding-bottom: 1.5rem;
            }

            .header {
                height: 10rem;
            }

            .header img {
                width: 85%;
                max-width: 280px;
            }

            .social-icons {
                flex-wrap: wrap;
                gap: 0.5rem;
                justify-content: center;
                padding: 0 1rem;
            }

            .text-content p {
                padding-top: 0.75rem;
                padding-bottom: 0.75rem;
                font-size: 0.9rem;
            }

            .contact-item {
                gap: 0.5rem;
            }

            .contact-item img {
                padding: 0.5rem;
            }

            .contact-detail {
                font-size: 0.85rem;
            }

            .emaiIcon {
                width: 2rem;
            }

            .logo {
                min-width: 15rem;
                margin: 0px auto;
                min-height: 5rem;
            }
        }


        /* Large Screen Breakpoint (above 1280px) */
        @media screen and (min-width: 1280px) {

            body.bg-dark {
                background-color: #010510;
                padding: 0px;
            }

            .container {
                padding: 0px;
                margin: 0px auto;
                width: 100%;
            }

            .body-content {
                padding: 1.25rem 6rem;
                margin: 8rem 0px;
            }

            .contact-grid {
                gap: 2rem;
            }
        }
    </style>


</head>

<body class="bg-dark py-6">

    <div class="container">
        <div class="email-content">
            <div class="header">
                <div class="header-content">

                    <img src="{{ asset('assets/images/' . site('logo_rec')) }}" alt="icon" class="logo">
                </div>
            </div>

            <div class="body-content">
                <div class="text-content">

                    {{-- main content --}}
                    {{ Illuminate\Mail\Markdown::parse($slot) }}

                    {{ $subcopy ?? '' }}


                </div>
            </div>

            <div class="footer">
                <div class="contact-info">
                    <div class="contact-grid">
                        <div class="contact-item">
                            <div class="icon-container">

                                <svg class="emaiIcon" viewBox="0 0 61 60" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M55.1799 15C55.1799 12.25 52.9299 10 50.1799 10H10.1799C7.42993 10 5.17993 12.25 5.17993 15V45C5.17993 47.75 7.42993 50 10.1799 50H50.1799C52.9299 50 55.1799 47.75 55.1799 45V15ZM50.1799 15L30.1799 27.5L10.1799 15H50.1799ZM50.1799 45H10.1799V20L30.1799 32.5L50.1799 20V45Z"
                                        fill="#0040BC" />
                                </svg>

                            </div>
                            <div>
                                <p class="contact-title">Email</p>
                                <p class="contact-detail">{{ site('email') }}</p>
                            </div>
                        </div>

                        <div class="contact-item">
                            <div class="icon-container">

                                <svg class="emaiIcon" viewBox="0 0 60 60" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M20.43 39.5726C30.0425 49.1851 38.95 50.2376 41.565 50.3351C44.725 50.4501 47.95 47.87 49.345 45.2276C47.12 42.6175 44.2225 40.5926 41.05 38.3976C39.1775 40.2676 36.87 43.7426 33.7975 42.4976C32.05 41.7951 27.735 39.8075 23.965 36.035C20.195 32.2626 18.2075 27.9501 17.5 26.2051C16.255 23.1276 19.74 20.8151 21.6125 18.9426C19.4175 15.7176 17.4275 12.745 14.8225 10.6326C12.1425 12.0325 9.5475 15.2326 9.665 18.4351C9.7625 21.0501 10.815 29.9576 20.43 39.5726ZM41.38 55.3326C37.78 55.2001 27.5775 53.7901 16.8925 43.1076C6.21 32.4226 4.8025 22.2225 4.6675 18.6201C4.4675 13.1301 8.6725 7.79755 13.53 5.71505C14.1149 5.46247 14.7555 5.3663 15.3888 5.43599C16.0221 5.50568 16.6265 5.73882 17.1425 6.11255C21.1625 9.04505 23.935 13.4876 26.3175 16.9676C26.8131 17.6912 27.0402 18.5653 26.9594 19.4387C26.8786 20.312 26.495 21.1296 25.875 21.75L22.485 25.1426C23.2725 26.8801 24.875 29.8751 27.5 32.5C30.125 35.125 33.12 36.7275 34.86 37.515L38.2475 34.125C38.8695 33.5024 39.6907 33.1185 40.5673 33.0403C41.444 32.9622 42.3201 33.1948 43.0425 33.6976C46.5925 36.1576 50.7625 38.8901 53.8025 42.7826C54.2066 43.3023 54.4636 43.9211 54.5467 44.5742C54.6298 45.2272 54.536 45.8906 54.275 46.495C52.1825 51.3775 46.8875 55.535 41.38 55.3326Z"
                                        fill="#0040BC" />
                                </svg>

                            </div>
                            <div>
                                <p class="contact-title">Phone</p>
                                <p class="contact-detail">{{ site('phone') }}</p>
                            </div>
                        </div>

                        <div class="contact-item full-width">
                            <div class="icon-container">

                                <svg class="emaiIcon" viewBox="0 0 60 60" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M30 5C19 5 10 14 10 25C10 38.5 27.5 53.75 28.25 54.5C28.75 54.75 29.5 55 30 55C30.5 55 31.25 54.75 31.75 54.5C32.5 53.75 50 38.5 50 25C50 14 41 5 30 5ZM30 49.25C24.75 44.25 15 33.5 15 25C15 16.75 21.75 10 30 10C38.25 10 45 16.75 45 25C45 33.25 35.25 44.25 30 49.25ZM30 15C24.5 15 20 19.5 20 25C20 30.5 24.5 35 30 35C35.5 35 40 30.5 40 25C40 19.5 35.5 15 30 15ZM30 30C27.25 30 25 27.75 25 25C25 22.25 27.25 20 30 20C32.75 20 35 22.25 35 25C35 27.75 32.75 30 30 30Z"
                                        fill="#0040BC" />
                                </svg>

                            </div>
                            <div>
                                <p class="contact-title">Location</p>
                                <p class="contact-detail">{{ site('address') }}, {{ site('city') }},
                                    {{ site('state') }}, {{ site('country') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="unsubscribe">


                    <ul class="social-icons">

                        @php
                            $socialMedia = ['instagram', 'facebook', 'pinterest', 'twitter', 'youtube', 'linkedin'];
                        @endphp
                        @foreach ($socialMedia as $media)
                            @if (site($media))
                                <li>
                                    <div class="social-icon">
                                        <a href="{{ site($media) }}">
                                            <img src="{{ asset('/assets/templates/dome/images/front/icon/pink_social_icon_' . $media . '.svg') }}"
                                                alt="icon">
                                        </a>
                                    </div>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>

            </div>

        </div>
    </div>


</body>

</html>
