@extends('templates.' . site('template') . '.layouts.auth')

@section('css')
    <style>
        input {
            background-color: transparent;
            color: inherit;
            /* Keeps text color consistent */
            border: none;
            outline: none;
        }
    </style>
@endsection

@section('contents')
    <div class="h-screen w-full flex items-center relative" data-aos="zoom-in-up">
        <img src="{{ asset('/assets/templates/valent/images/blockchain-3d-render-icon-b 1.png') }}" alt="crypto"
            class="w-[924px] absolute right-0 lg:block hidden">

        <div class="w-full h-[60vh] grid lg:grid-cols-2 lg:p-0 p-4">

            <div class="col-span-1">

                <div class="max-w-screen-sm mx-auto" data-aos="fade-right">


                    <a href="{{ route('home') }}">
                        <p class="text-white flex gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                <path d="M12.707 17.293 8.414 13H18v-2H8.414l4.293-4.293-1.414-1.414L4.586 12l6.707 6.707z">
                                </path>
                            </svg>
                            <span>Back</span>
                        </p>
                    </a>

                    <div class="px-4 lg:px-10 mt-6 space-y-6">
                        <p class="bg-green-500 text-gray-300 p-1 rounded-lg text-xs text-center hidden noticeMsg"
                            id="noticeMsg" style="background: #1ce01c; color:#fff; margin:10px 0px;"></p>
                    </div>

                    <div class="text-white mb-10">
                        <p class="text-4xl mb-4 font-thin">Get Started with <span
                                class="font-bold bg-gradient-to-r from-[#3F7DF2] via-[#09C241] to-[#ffffff] bg-clip-text text-transparent">G-Trade Ai</span>
                        </p>
                        <p class="">Please enter your details</p>
                    </div>

                    <form action="{{ route('user.register-validate') }}" method="POST" class="" id="registerForm">
                        @csrf
                        <div class="w-full mb-10">
                            <fieldset class="border py-1 px-3 rounded-2xl">
                                <legend class="px-3 mx-8 text-white"><label for="amount"
                                        class="text-white text-sm">Email</label></legend>
                                <div class="w-full text-white flex gap-4">
                                    <img src="{{ asset('/assets/templates/valent/images/icon/user_card_gradient.svg') }}"
                                        alt="icon">
                                    <div class="w-full">
                                        <input type="email" id="email" name="email"
                                            class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Enter Email">
                                    </div>
                                </div>
                            </fieldset>

                            <span>
                                @error('email')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>

                        <div class="w-full mb-4">
                            <fieldset class="border py-1 px-3 rounded-2xl">
                                <legend class="px-3 mx-8 text-white"><label for="amount"
                                        class="text-white text-sm">Password</label></legend>
                                <div class="w-full text-white flex gap-4">
                                    <img src="{{ asset('/assets/templates/valent/images/icon/pass_card_gradient.svg') }}"
                                        alt="icon">
                                    <div class="w-full">
                                        <input type="password" name="password" placeholder="Enter Password" id="password"
                                            class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Enter Password">
                                    </div>
                                </div>
                            </fieldset>

                            <span>
                                @error('password')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>

                        <div class="w-full mb-20">
                            <fieldset class="border py-1 px-3 rounded-2xl">
                                <legend class="px-3 mx-8 text-white"><label for="amount"
                                        class="text-white text-sm">Confirm Password</label></legend>
                                <div class="w-full text-white flex gap-4">
                                    <img src="{{ asset('/assets/templates/valent/images/icon/pass_card_gradient.svg') }}"
                                        alt="icon">
                                    <div class="w-full">
                                        <input type="password" name="password_confirmation" placeholder="Re-enter Password"
                                            id="confirm-password"
                                            class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1">
                                    </div>
                                </div>
                            </fieldset>

                            <span>
                                @error('password-confirmation')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>


                        <div class="w-full mb-4">
                            <div class="text-center">
                                <button type="submit" id="registerBtn"
                                    class="border bg-gradient-to-r from-[#3271E8] to-[#0A4AC5] text-white hover:bg-blue-600 rounded-full px-10 py-4 w-full hover:text-[#0040BC] hover:bg-gradient-to-r hover:from-[#3F7DF2] hover:via-[#FFFFFF] hover:to-[#09C241] transition delay-100 duration-200 ease-in-out">Sign
                                    Up</button>
                            </div>
                        </div>

                        <div class="w-full mb-4">
                            <p class="text-center text-[#B4B1B1]"> Already have an account? <a
                                    href="{{ route('user.login') }}" class="text-white"> Login</a></p>
                        </div>

                    </form>


                    {{-- verification form --}}

                    <form action="{{ route('user.register-verify') }}" method="POST" class="hidden" id="verifyForm">
                        @csrf

                        <div class="w-full mb-10 flex items-center justify-center">
                            <div class="relative">

                                <div class="flex lg:gap-10 gap-6 text-white">
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                    <input type="number" maxlength="1" name="otp[]"
                                        class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                </div>

                                <input type="hidden" name="otp" placeholder="OTP" id="otp"
                                    class="theme1-text-input" required maxlength="6">
                                <span>
                                    @error('email')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>

                        <div class="w-full mb-4 pt-10">
                            <div class="text-center">
                                <button type="submit" id="verifyBtn"
                                    class="border bg-gradient-to-r from-[#3271E8] to-[#0A4AC5] text-white hover:bg-blue-600 rounded-full px-10 lg:py-4 py-2 w-full hover:text-[#0040BC] hover:bg-gradient-to-r hover:from-[#3F7DF2] hover:via-[#FFFFFF] hover:to-[#09C241] transition delay-100 duration-200 ease-in-out">Verify</button>
                            </div>

                            <div class="text-center text-white py-5">
                                <a href="{{ route('user.register') }}" class="hover:text-purple-700" id="resendBtn">Go
                                    Back</a>
                            </div>
                        </div>


                    </form>

                </div>
            </div>

        </div>

    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#registerForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#registerBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                clicked.addClass('bg-gray-500');
                clicked.removeClass('bg-gradient-to-r hover:bg-blue-600 hover:bg-gradient-to-r');

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        var verify = response.verify;

                        toastNotify('success', verifyText);
                        $('.noticeMsg').html(verifyText).show();

                        if (verify == 1) {
                            //hide register form and display verification form
                            $('#registerForm').hide();
                            $('#verifyForm').show();

                            //update page title
                            $('#page-title').html('Verify Email');
                        } else {
                            var url = '{{ route('user.dashboard') }}';
                            window.location.href = url;
                        }




                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                toastNotify('error', fieldErrors);

                                $('.noticeMsg').html(fieldErrors).show();


                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');


                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        clicked.removeClass('bg-gray-500');
                        clicked.addClass(
                            'bg-gradient-to-r hover:bg-blue-600 hover:bg-gradient-to-r');

                    }

                });
            });


            //otp form
            $('#verifyForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#verifyBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                clicked.removeClass('bg-gray-500');
                clicked.addClass('bg-gradient-to-r hover:bg-blue-600 hover:bg-gradient-to-r');

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        $('#noticeMsg').html(verifyText).show();

                        toastNotify('success', verifyText);



                        var url = '{{ route('user.dashboard') }}';
                        window.location.href = url;

                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });

                                toastNotify('error', fieldErrors);

                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');

                        }


                    },

                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        clicked.removeClass('bg-gray-500');
                        clicked.addClass(
                            'bg-gradient-to-r hover:bg-blue-600 hover:bg-gradient-to-r');

                    }

                });
            });
        });
    </script>

    {{-- <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, 4);

                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script> --}}


    <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                // Allow only 1 character
                if (value.length > 1) {
                    $this.val(value.charAt(0)); // Keep only the first character
                }

                // Move focus to the next input if a character is entered
                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, $inputs.length);

                // Fill inputs with pasted data, ensuring only one character per input
                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });

                // Focus on the next input after the last pasted character
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script>
@endsection
