<div class="w-full">
    <div class="w-full flex justify-between items-center">
        <div>
            <!-- Previous Page Link -->
            <?php if($paginator->onFirstPage()): ?>
                <div class="disabled"><span>&laquo;</span></div>
            <?php else: ?>
                <div><a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev">&laquo;</a></div>
            <?php endif; ?>
        </div>

        <div class="w-full md:w-3/4 flex justify-center space-x-1 overflow-hidden">
            <!-- Pagination Links -->
            <?php
                $pageCount = $paginator->lastPage();
                $currentPage = $paginator->currentPage();
                $startIndex = $currentPage <= 2 ? 1 : max($currentPage - 2, 1);
                $endIndex = $currentPage <= 2 ? min($pageCount, 6) : min($currentPage + 2, $pageCount);
            ?>

            

            <?php for($i = $startIndex; $i <= $endIndex; $i++): ?>
                <?php if($i == $currentPage): ?>
                    <div
                        class="bg-purple-500 px-3 rounded border border-slate-800 hover:border-slate-600 cursor-pointer hover:scale-110 transition-all paginator-link">
                        <span><?php echo e($i); ?></span>
                    </div>
                <?php else: ?>
                    <a class="px-3 rounded border border-slate-800 hover:border-slate-600 cursor-pointer hover:scale-110 transition-all paginator-link"
                        href="<?php echo e($paginator->url($i)); ?>"><?php echo e($i); ?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if($currentPage < $pageCount - 1): ?>
                <div class="disabled"><span>...</span></div>
                <a href="<?php echo e($paginator->url($pageCount)); ?>"
                    class="px-3 rounded border border-slate-800 hover:border-slate-600 cursor-pointer hover:scale-110 transition-all paginator-link">
                    <?php echo e($pageCount); ?>

                </a>
            <?php endif; ?>
        </div>

        <div>
            <!-- Next Page Link -->
            <?php if($paginator->hasMorePages()): ?>
                <div><a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="paginator-link">&raquo;</a></div>
            <?php else: ?>
                <div class="disabled"><span>&raquo;</span></div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/paginations/simple.blade.php ENDPATH**/ ?>