<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#07030c">
    <meta name="theme-color" content="#07030c">

    <link rel="apple-touch-icon" href="<?php echo e(asset('assets/images/' . site('favicon'))); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/' . site('favicon'))); ?>">

    <title><?php echo e($page_title); ?> | <?php echo e(site('name')); ?></title>
    <meta name="author" content="support@rescron.com">
    <meta name="description" content="<?php echo e(site('seo_description')); ?>">
    <meta property="og:url" content="<?php echo e(request()->url); ?>">
    <meta property="og:title" content="<?php echo e($page_title); ?> | <?php echo e(site('name')); ?>">
    <meta property="og:description" content="<?php echo e(site('seo_description')); ?>">
    <meta property="og:image" content="<?php echo e(asset('assets/images/' . site('cover'))); ?>">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">

    <link rel="stylesheet" href="<?php echo e(asset('/assets/templates/valent/css/output.css?v=1.2')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/templates/valent/css/front_main.css')); ?>">

    <style>
        .button-spinner {
            border: 4px solid #f3f3f3;
            /* Light grey background */
            border-top: 4px solid #3498db;
            /* Blue color for the spinner */
            border-radius: 50%;
            width: 25px;
            height: 25px;
            animation: spin 1s linear infinite;
            /* Spinning animation */
            display: inline-block;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .not-allowed-cursor {
            cursor: not-allowed;
        }
    </style>
</head>

<body class="bg-black"
    style="background-image: url(<?php echo e(asset('/assets/templates/valent/images/dash_background.png')); ?>);">

    <?php if(site('preloader') == 1): ?>
        <?php echo $__env->make('templates.' . site('template') . '.loaders.front_preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- template-->
    <div class="w-full h-screen">

        <?php echo $__env->yieldContent('contents'); ?>

    </div>


    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>

    <script src="<?php echo e(asset('/assets/templates/valent/scripts/front_main.js')); ?>"></script>

    <?php echo $__env->yieldContent('scripts'); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    
    <?php echo json_decode(site('livechat')); ?>

</body>

</html>
<?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/templates/valent/layouts/auth.blade.php ENDPATH**/ ?>