<!DOCTYPE html>
<html lang="en">

<head>
    <title><?php echo e(site('name')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">

    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: black;
            padding: 24px 0;
            font-family: 'Noto Sans', sans-serif;
        }

        .container {
            width: 100%;
            overflow: auto;
            padding: 12px;
        }

        .email-wrapper {
            max-width: 1200px;
            background-color: white;
            margin: auto;
        }

        .header {
            height: 25vh;
            background-color: #C3D8FF;
            display: flex;
            align-items: center;
            position: relative;
        }

        .header img.bg-img {
            position: absolute;
            right: 0;
            height: 100%;
        }

        .header .overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.2);
            display: flex;
            align-items: center;
            padding: 0 40px;
        }

        .content {
            width: 100%;
            padding: 7rem 20px;
            margin-bottom: 40px;
            font-size: 18px;
            line-height: 1.6;
            text-align: justify;
            display: block;
            box-sizing: border-box;
        }

        .footer {
            width: 100%;
            text-align: center;
            margin-bottom: 10px;
        }

        .footer p {
            color: #B4B1B1;
            margin-bottom: 12px;
        }

        .social-icons {
            display: flex;
            justify-content: center;
            gap: 10px;
        }

        .social-icons div {
            padding: 10px;
            background-color: #F9F8F8;
            border-radius: 6px;
        }

        .contact-section {
            background-color: #3F7DF2;
            width: 95%;
            margin: auto;
            border-radius: 10px 10px 0 0;
            padding: 16px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .contact-item {
            display: flex;
            gap: 10px;
            align-items: center;
            color: white;
            flex: 1 1 30%;
        }

        .contact-icon {
            padding: 12px;
            background-color: rgba(255, 255, 255, 0.15);
            border-radius: 50%;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="email-wrapper">
            <div class="header">
                <img src="<?php echo e(asset('assets/templates/valent/images/vector-illustration-bitcoin-crypto1.png')); ?>"
                    alt="crypto-img" class="bg-img">
                <div class="overlay">
                    <img src="<?php echo e(asset('assets/images/' . site('logo_rec'))); ?>" alt="logo">
                </div>
            </div>
            <div class="content" style="margin:7rem 0px;">

                <?php echo e(Illuminate\Mail\Markdown::parse($slot)); ?>


                <?php echo e($subcopy ?? ''); ?>


            </div>
            <div class="footer">

                <div class="social-icons">
                    <?php
                        $socialMedia = ['instagram', 'facebook', 'pinterest', 'twitter', 'youtube', 'linkedin'];
                    ?>
                    <?php $__currentLoopData = $socialMedia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(site($media)): ?>
                            <div>
                                <a href="<?php echo e(site($media)); ?>">
                                    <img src="<?php echo e(asset('/assets/templates/valent/images/icon/blue_social_icon_' . $media . '.svg')); ?>"
                                        alt="icon">
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
            <div class="contact-section">
                <div class="contact-item">
                    <div class="contact-icon"><img
                            src="<?php echo e(asset('assets/templates/valent/images/icon/white-outline-email.svg')); ?>"
                            alt="icon">
                    </div>
                    <div>
                        <p><strong>Email</strong></p>
                        <p><?php echo e(site('email')); ?></p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><img
                            src="<?php echo e(asset('assets/templates/valent/images/icon/white-outline-phone-line.svg')); ?>"
                            alt="icon"></div>
                    <div>
                        <p><strong>Phone</strong></p>
                        <p><?php echo e(site('phone')); ?></p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon"><img
                            src="<?php echo e(asset('assets/templates/valent/images/icon/white-outline-location.svg')); ?>"
                            alt="icon"></div>
                    <div>
                        <p><strong>Location</strong></p>
                        <p><?php echo e(site('address')); ?>, <?php echo e(site('city')); ?>, <?php echo e(site('state')); ?>, <?php echo e(site('country')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/templates/valent/vendor/mail/html/layout.blade.php ENDPATH**/ ?>